/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.DeveloperServices;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeveloperServiceMap {
    private HashMap<String, DeveloperServiceList> myServiceCache;

    public DeveloperServiceMap(@NotNull Set<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/structure/services/DeveloperServiceMap", "<init>"));
        }
        this.myServiceCache = new HashMap();
        for (Module module : modules) {
            for (DeveloperService service : DeveloperServices.getAll(module)) {
                this.put(service.getMetadata().getId(), service);
            }
        }
    }

    private void put(@NotNull String key, @NotNull DeveloperService service) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/DeveloperServiceMap", "put"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/android/tools/idea/structure/services/DeveloperServiceMap", "put"));
        }
        if (this.myServiceCache.containsKey(key)) {
            List developerServices = this.myServiceCache.get(key);
            developerServices.add(service);
            return;
        }
        DeveloperServiceList services = new DeveloperServiceList();
        services.add(service);
        this.myServiceCache.put(key, services);
    }

    @Nullable(value="Null when key doesn't match known services")
    public DeveloperServiceList get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/DeveloperServiceMap", "get"));
        }
        return this.myServiceCache.get(key);
    }

    @Nullable(value="Null if no pairing found.")
    public DeveloperService get(@NotNull String key, @NotNull Module module) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/DeveloperServiceMap", "get"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/DeveloperServiceMap", "get"));
        }
        List services = this.myServiceCache.get(key);
        for (DeveloperService service : services) {
            if (!service.getModule().equals(module)) continue;
            return service;
        }
        DeveloperServiceMap.getLog().error("No service found for module " + module.getName());
        return null;
    }

    private static Logger getLog() {
        return Logger.getInstance(DeveloperServiceMap.class);
    }

    public static class DeveloperServiceList
    extends ArrayList<DeveloperService> {
        private Set<Module> myModules = new HashSet<Module>();

        @Nullable(value="Null if no pairing found.")
        public DeveloperService get(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/DeveloperServiceMap$DeveloperServiceList", "get"));
            }
            for (DeveloperService service : this) {
                if (!service.getModule().equals(module)) continue;
                return service;
            }
            DeveloperServiceMap.getLog().error("No service found for module " + module.getName());
            return null;
        }

        @Nullable(value="Null when no services found.")
        public Project getProject() {
            if (this.size() == 0) {
                return null;
            }
            return ((DeveloperService)this.get(0)).getModule().getProject();
        }

        @Nullable(value="If no service in list.")
        public DeveloperServiceMetadata getMetadata() {
            if (this.size() == 0) {
                return null;
            }
            return ((DeveloperService)this.get(0)).getMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<Module> getModules() {
            DeveloperServiceList developerServiceList = this;
            synchronized (developerServiceList) {
                if (this.myModules.isEmpty()) {
                    for (DeveloperService service : this) {
                        this.myModules.add(service.getModule());
                    }
                }
            }
            Set<Module> set = this.myModules;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMap$DeveloperServiceList", "getModules"));
            }
            return set;
        }
    }
}

