/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressIndicatorAdapter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    private com.intellij.openapi.progress.ProgressIndicator myStudioProgressIndicator;

    public StudioDownloader() {
    }

    public StudioDownloader(com.intellij.openapi.progress.ProgressIndicator progress) {
        this.myStudioProgressIndicator = progress;
    }

    public InputStream downloadAndStream(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/sdk/StudioDownloader", "downloadAndStream"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/StudioDownloader", "downloadAndStream"));
        }
        final File file = this.downloadFully(url, indicator);
        if (file == null) {
            return null;
        }
        file.deleteOnExit();
        return new FileInputStream(file){

            @Override
            public void close() throws IOException {
                super.close();
                file.delete();
            }
        };
    }

    public void downloadFully(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/sdk/StudioDownloader", "downloadFully"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/StudioDownloader", "downloadFully"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/StudioDownloader", "downloadFully"));
        }
        if (target.exists() && checksum != null && checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
            return;
        }
        indicator.logInfo("Downloading " + url);
        indicator.setText("Downloading...");
        indicator.setSecondaryText(url.toString());
        com.intellij.openapi.progress.ProgressIndicator studioProgress = this.myStudioProgressIndicator;
        if (studioProgress == null) {
            studioProgress = ProgressManager.getInstance().getProgressIndicator();
        }
        HttpRequests.request((String)url.toExternalForm()).saveToFile(target, (com.intellij.openapi.progress.ProgressIndicator)new StudioProgressIndicatorAdapter(indicator, studioProgress));
    }

    public File downloadFully(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/sdk/StudioDownloader", "downloadFully"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/StudioDownloader", "downloadFully"));
        }
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf("/") + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile;
    }
}

