/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class SetFirebaseLogTagsTask
implements LaunchTask {
    @Override
    @NotNull
    public String getDescription() {
        if ("Setting Firebase Log Properties on the device" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "getDescription"));
        }
        return "Setting Firebase Log Properties on the device";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "perform"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "lambda$perform$0"));
            }
            try {
                NullOutputReceiver receiver = new NullOutputReceiver();
                device.executeShellCommand("setprop log.tag.FA VERBOSE", (IShellOutputReceiver)receiver);
                device.executeShellCommand("setprop log.tag.FA-SVC VERBOSE", (IShellOutputReceiver)receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return true;
    }

    public static boolean projectUsesFirebase(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/SetFirebaseLogTagsTask", "projectUsesFirebase"));
        }
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        if (model == null) {
            return false;
        }
        return GradleUtil.dependsOn(model, "com.google.android.gms:firebase-measurement") || GradleUtil.dependsOn(model, "com.google.firebase:firebase-measurement") || GradleUtil.dependsOn(model, "com.google.firebase:firebase-analytics");
    }
}

