/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.UsageTracker;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
implements LaunchTask {
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "<init>"));
        }
        if (startActivityFlagsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startActivityFlagsProvider", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "<init>"));
        }
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Launching URL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getDescription"));
        }
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.getInstance().trackEvent("appIndexing", "deepLinkLaunched", null, null);
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device));
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, 5L, TimeUnit.SECONDS);
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        String string = "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + deepLink + (extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        return string;
    }
}

