/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActivityLocatorUtils {
    public static boolean containsAction(@NotNull Element filter, @NotNull String name) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsAction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsAction"));
        }
        for (Node action = filter.getFirstChild(); action != null; action = action.getNextSibling()) {
            if (action.getNodeType() != 1 || !"action".equals(action.getNodeName()) || !name.equals(((Element)action).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull Element filter, @NotNull String name) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsCategory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsCategory"));
        }
        for (Node action = filter.getFirstChild(); action != null; action = action.getNextSibling()) {
            if (action.getNodeType() != 1 || !"category".equals(action.getNodeName()) || !name.equals(((Element)action).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLauncherIntent(@NotNull DefaultActivityLocator.ActivityWrapper activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsLauncherIntent"));
        }
        return activity.hasAction("android.intent.action.MAIN") && (activity.hasCategory("android.intent.category.LAUNCHER") || activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER"));
    }

    @Nullable
    public static String getQualifiedName(@NotNull Element component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Attr nameNode = component.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (nameNode == null) {
            return null;
        }
        String name = nameNode.getValue();
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        Element root = component.getOwnerDocument().getDocumentElement();
        Attr pkgNode = root.getAttributeNode("package");
        if (pkgNode != null) {
            String pkg = pkgNode.getValue();
            return pkg + (dotIndex == -1 ? "." : "") + name;
        }
        return name;
    }

    @Nullable
    public static String getQualifiedName(@NotNull ActivityAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String name = alias.getName().getStringValue();
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        String pkg = null;
        DomElement parent = alias.getParent();
        if (parent instanceof Application && (parent = parent.getParent()) instanceof Manifest) {
            Manifest manifest = (Manifest)parent;
            pkg = manifest.getPackage().getStringValue();
        }
        return pkg == null ? name : pkg + (dotIndex == -1 ? "." : "") + name;
    }

    @Nullable
    public static String getQualifiedName(@NotNull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass c = (PsiClass)activity.getActivityClass().getValue();
        if (c == null) {
            Module module = activity.getModule();
            if (module != null && ApkProjects.isApkProject(module)) {
                return activity.getActivityClass().getStringValue();
            }
            return null;
        }
        return ActivityLocatorUtils.getQualifiedActivityName(c);
    }

    @Nullable
    public static String getQualifiedActivityName(@NotNull PsiClass c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedActivityName"));
        }
        return PackageClassConverter.getQualifiedName(c);
    }
}

