/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceStateCache;
import com.google.common.hash.HashCode;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPatchCache
implements Disposable {
    private final DeviceStateCache<PatchState> myCache = new DeviceStateCache(this);

    @Nullable
    public HashCode getInstalledManifestResourcesHash(@NotNull IDevice device, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestResourcesHash"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestResourcesHash"));
        }
        PatchState state = this.getState(device, pkgName, false);
        return state == null ? null : state.manifestResources;
    }

    public void setInstalledManifestResourcesHash(@NotNull IDevice device, @NotNull String pkgName, HashCode hash) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestResourcesHash"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestResourcesHash"));
        }
        this.getState((IDevice)device, (String)pkgName, (boolean)true).manifestResources = hash;
    }

    @Contract(value="!null, !null, true -> !null")
    @Nullable
    private PatchState getState(@NotNull IDevice device, @NotNull String pkgName, boolean create) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "getState"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "getState"));
        }
        PatchState state = this.myCache.get(device, pkgName);
        if (state == null && create) {
            state = new PatchState();
            this.myCache.put(device, pkgName, state);
        }
        return state;
    }

    public void dispose() {
    }

    private static class PatchState {
        @Nullable
        public HashCode manifestResources;

        private PatchState() {
        }
    }
}

