/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileSystemApkProvider
implements ApkProvider {
    private final Module myModule;
    private final File myApkPath;

    public FileSystemApkProvider(@NotNull Module module, @NotNull File apkFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/run/FileSystemApkProvider", "<init>"));
        }
        if (apkFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkFile", "com/android/tools/idea/run/FileSystemApkProvider", "<init>"));
        }
        this.myModule = module;
        this.myApkPath = apkFile;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/FileSystemApkProvider", "getApks"));
        }
        MergedManifest manifest = MergedManifest.get(this.myModule);
        String id = manifest.getApplicationId();
        if (id == null) {
            throw new ApkProvisionException("Invalid manifest, no package name specified");
        }
        ArrayList apkList = Lists.newArrayList();
        apkList.add(new ApkInfo(this.myApkPath, id));
        ArrayList arrayList = apkList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/FileSystemApkProvider", "getApks"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/FileSystemApkProvider", "validate"));
        }
        return immutableList;
    }
}

