/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.GutterIconCache;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    private final PsiElement myElement;
    private final File myFile;
    private Icon myIcon;

    public GutterIconRenderer(@NotNull PsiElement element, @NotNull File file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/rendering/GutterIconRenderer", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/GutterIconRenderer", "<init>"));
        }
        this.myElement = element;
        this.myFile = file;
    }

    @NotNull
    public Icon getIcon() {
        if (this.myIcon == null) {
            this.myIcon = GutterIconCache.getInstance().getIcon(this.myFile.getPath());
            if (this.myIcon == null) {
                this.myIcon = AllIcons.General.Error;
            }
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/GutterIconRenderer", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                if (editor != null) {
                    Project project = editor.getProject();
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(GutterIconRenderer.this.myFile);
                    if (project != null && virtualFile != null) {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, -1);
                        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                    }
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + this.myFile.hashCode();
        return result;
    }
}

