/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjects {
    private static final Logger LOG = Logger.getInstance(NewProjects.class);

    public static void createIdeaProjectDir(@NotNull File projectRootDirPath) throws IOException {
        if (projectRootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDirPath", "com/android/tools/idea/project/NewProjects", "createIdeaProjectDir"));
        }
        File ideaDirPath = new File(projectRootDirPath, ".idea");
        if (ideaDirPath.isDirectory()) {
            boolean librariesDirDeleted;
            File librariesDir = new File(ideaDirPath, "libraries");
            if (librariesDir.exists() && !(librariesDirDeleted = FileUtil.delete((File)librariesDir))) {
                LOG.info(String.format("Failed to delete %1$s'", librariesDir.getPath()));
            }
        } else {
            FileUtil.ensureExists((File)ideaDirPath);
        }
    }

    @NotNull
    public static Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/project/NewProjects", "createProject"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/project/NewProjects", "createProject"));
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new IDEA project");
        }
        Project project = newProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/NewProjects", "createProject"));
        }
        return project;
    }

    public static void activateProjectView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/NewProjects", "activateProjectView"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (window != null) {
            window.activate(null, false);
        }
    }

    public static void createRunConfigurations(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/project/NewProjects", "createRunConfigurations"));
        }
        Module module = facet.getModule();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        ConfigurationFactory configurationFactory = AndroidRunConfigurationType.getInstance().getFactory();
        List configs = runManager.getConfigurationsList(configurationFactory.getType());
        for (RunConfiguration config : configs) {
            AndroidRunConfiguration androidRunConfig;
            if (!(config instanceof AndroidRunConfiguration) || ((JavaRunConfigurationModule)(androidRunConfig = (AndroidRunConfiguration)config).getConfigurationModule()).getModule() != module) continue;
            return;
        }
        AndroidUtils.addRunConfiguration(facet, null, false, TargetSelectionMode.SHOW_DIALOG, null);
    }
}

