/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    private static final Key<Boolean> HAS_NATIVE_MODULES = Key.create((String)"HAS_NATIVE_MODULES");
    @NotNull
    private final Project myProject;

    private AndroidProjectInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectInfo", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public static AndroidProjectInfo get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectInfo", "get"));
        }
        AndroidProjectInfo androidProjectInfo = new AndroidProjectInfo(project);
        if (androidProjectInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/AndroidProjectInfo", "get"));
        }
        return androidProjectInfo;
    }

    public void setHasNativeModules(boolean hasNativeModules) {
        this.myProject.putUserData(HAS_NATIVE_MODULES, (Object)hasNativeModules);
    }

    public boolean hasNativeModules() {
        Boolean boolRes = (Boolean)this.myProject.getUserData(HAS_NATIVE_MODULES);
        return boolRes != null ? boolRes : false;
    }
}

