/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.actions.NewAndroidComponentAction;
import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateListProvider;
import com.android.tools.idea.npw.ThemeHelper;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityGalleryStep
extends DynamicWizardStepWithDescription {
    private static final ScopedStateStore.Key<TemplateEntry[]> KEY_TEMPLATES = ScopedStateStore.createKey("template.list", ScopedStateStore.Scope.STEP, TemplateEntry[].class);
    @NotNull
    private final FormFactor myFormFactor;
    private final ScopedStateStore.Key<TemplateEntry> myCurrentSelectionKey;
    private final boolean myShowSkipEntry;
    private final Module myModule;
    private boolean myAppThemeExists;
    private ASGallery<Optional<TemplateEntry>> myGallery;

    public ActivityGalleryStep(@NotNull FormFactor formFactor, boolean showSkipEntry, @NotNull ScopedStateStore.Key<TemplateEntry> currentSelectionKey, @Nullable Module module, @NotNull Disposable disposable) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/ActivityGalleryStep", "<init>"));
        }
        if (currentSelectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSelectionKey", "com/android/tools/idea/npw/ActivityGalleryStep", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/npw/ActivityGalleryStep", "<init>"));
        }
        super(disposable);
        this.myFormFactor = formFactor;
        this.myCurrentSelectionKey = currentSelectionKey;
        this.myShowSkipEntry = showSkipEntry;
        this.myModule = module;
        this.setBodyComponent(this.createGallery());
    }

    private JComponent createGallery() {
        this.myGallery = new ASGallery();
        Dimension thumbnailSize = WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE;
        this.myGallery.setThumbnailSize(thumbnailSize);
        this.myGallery.setMinimumSize(new Dimension(thumbnailSize.width * 2 + 1, thumbnailSize.height));
        this.myGallery.setLabelProvider(new Function<Optional<TemplateEntry>, String>(){

            public String apply(Optional<TemplateEntry> template) {
                if (template.isPresent()) {
                    return ((TemplateEntry)template.get()).getTitle();
                }
                return "Add No Activity";
            }
        });
        this.myGallery.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicWizard wizard = ActivityGalleryStep.this.getWizard();
                assert (wizard != null);
                wizard.doNextAction();
            }
        });
        this.myGallery.setImageProvider(new Function<Optional<TemplateEntry>, Image>(){

            public Image apply(Optional<TemplateEntry> input) {
                return input.isPresent() ? ((TemplateEntry)input.get()).getImage() : null;
            }
        });
        this.myGallery.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ActivityGalleryStep.this.saveState((JComponent)((Object)ActivityGalleryStep.this.myGallery));
            }
        });
        this.myGallery.setName("Templates Gallery");
        AccessibleContext accessibleContext = this.myGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getStepTitle());
        }
        JPanel panel = new JPanel((LayoutManager)new JBCardLayout());
        panel.add("only card", (Component)new JBScrollPane(this.myGallery));
        return panel;
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        UiNotifyConnector.doWhenFirstShown(this.myGallery, (Runnable)new Runnable(){

            @Override
            public void run() {
                ActivityGalleryStep.this.myGallery.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        this.myAppThemeExists = this.myState.getNotNull(WizardConstants.IS_NEW_PROJECT_KEY, false);
        if (this.myModule != null) {
            ThemeHelper themeHelper = new ThemeHelper(this.myModule);
            this.myAppThemeExists = themeHelper.getAppThemeName() != null;
        }
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.getNotNull(WizardConstants.IS_LIBRARY_KEY, false) == false && super.isStepVisible();
    }

    @Override
    public boolean validate() {
        TemplateEntry template = this.myState.get(this.myCurrentSelectionKey);
        PageStatus status = template == null ? (this.myShowSkipEntry ? PageStatus.OK : PageStatus.NOTHING_SELECTED) : (this.isIncompatibleMinSdk(template) ? PageStatus.INCOMPATIBLE_MAIN_SDK : (this.isIncompatibleBuildApi(template) ? PageStatus.INCOMPATIBLE_BUILD_API : (this.isMissingAppTheme(template) ? PageStatus.MISSING_THEME : PageStatus.OK)));
        this.setErrorHtml(status.formatMessage(template));
        return status.isPageValid();
    }

    private boolean isIncompatibleBuildApi(@NotNull TemplateEntry template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/npw/ActivityGalleryStep", "isIncompatibleBuildApi"));
        }
        Integer buildSdkLevel = this.myState.get(FormFactorUtils.getBuildApiLevelKey(this.myFormFactor));
        return buildSdkLevel != null && buildSdkLevel < template.getMinBuildApi();
    }

    private boolean isIncompatibleMinSdk(@NotNull TemplateEntry template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/npw/ActivityGalleryStep", "isIncompatibleMinSdk"));
        }
        Integer minSdkLevel = this.myState.get(FormFactorUtils.getMinApiLevelKey(this.myFormFactor));
        return minSdkLevel != null && minSdkLevel < template.getMinSdk();
    }

    private boolean isMissingAppTheme(@NotNull TemplateEntry template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/npw/ActivityGalleryStep", "isMissingAppTheme"));
        }
        return !this.myAppThemeExists && template.getMetadata().isAppThemeRequired();
    }

    @Override
    public void init() {
        super.init();
        TemplateListProvider templateListProvider = new TemplateListProvider(this.myFormFactor, NewAndroidComponentAction.NEW_WIZARD_CATEGORIES, TemplateManager.EXCLUDED_TEMPLATES);
        TemplateEntry[] list = templateListProvider.deriveValue(this.myState, AddAndroidActivityPath.KEY_IS_LAUNCHER, null);
        this.myGallery.setModel(JBList.createDefaultListModel((Object[])this.wrapInOptionals(list)));
        this.myState.put(KEY_TEMPLATES, list);
        if (list.length != 0) {
            int i = ActivityGalleryStep.indexOfTemplateWithTitle(list, "Empty Activity");
            this.myState.put(this.myCurrentSelectionKey, list[i == -1 ? 0 : i]);
        }
        this.register(this.myCurrentSelectionKey, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry, ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(TemplateEntry newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/ActivityGalleryStep$6", "setValue"));
                }
                component.setSelectedElement((Optional<TemplateEntry>)Optional.fromNullable((Object)newValue));
            }

            @Override
            @Nullable
            public TemplateEntry getValue(@NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/ActivityGalleryStep$6", "getValue"));
                }
                Optional<TemplateEntry> selection = component.getSelectedElement();
                if (selection != null && selection.isPresent()) {
                    return (TemplateEntry)selection.get();
                }
                return null;
            }
        });
        this.register(KEY_TEMPLATES, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry[], ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(@Nullable TemplateEntry[] newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/ActivityGalleryStep$7", "setValue"));
                }
                component.setModel(JBList.createDefaultListModel((Object[])ActivityGalleryStep.this.wrapInOptionals(newValue)));
            }
        });
        this.registerValueDeriver(KEY_TEMPLATES, templateListProvider);
    }

    private Optional[] wrapInOptionals(@Nullable TemplateEntry[] newValue) {
        int i;
        Optional[] model;
        if (newValue == null) {
            return new Optional[0];
        }
        if (this.myShowSkipEntry) {
            model = new Optional[newValue.length + 1];
            model[0] = Optional.absent();
            i = 1;
        } else {
            model = new Optional[newValue.length];
            i = 0;
        }
        for (TemplateEntry entry : newValue) {
            model[i++] = Optional.of((Object)entry);
        }
        return model;
    }

    private static int indexOfTemplateWithTitle(@NotNull TemplateEntry[] entries, @NotNull String title) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/android/tools/idea/npw/ActivityGalleryStep", "indexOfTemplateWithTitle"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/npw/ActivityGalleryStep", "indexOfTemplateWithTitle"));
        }
        for (int i = 0; i < entries.length; ++i) {
            if (!title.equals(entries[i].getMetadata().getTitle())) continue;
            return i;
        }
        return -1;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGallery;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Activity Gallery" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ActivityGalleryStep", "getStepName"));
        }
        return "Activity Gallery";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        String string = "Add an Activity to " + this.myFormFactor.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ActivityGalleryStep", "getStepTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    @Override
    @Nullable
    protected Icon getStepIcon() {
        return this.myFormFactor.getIcon();
    }

    private static enum PageStatus {
        OK,
        INCOMPATIBLE_BUILD_API,
        INCOMPATIBLE_MAIN_SDK,
        MISSING_THEME,
        NOTHING_SELECTED;


        public boolean isPageValid() {
            return this == OK;
        }

        @Nullable
        public String formatMessage(TemplateEntry template) {
            switch (this) {
                case OK: {
                    return null;
                }
                case INCOMPATIBLE_BUILD_API: {
                    return String.format("Selected activity template has a minimum build API level of %d.", template.getMinBuildApi());
                }
                case INCOMPATIBLE_MAIN_SDK: {
                    return String.format("Selected activity template has a minimum SDK level of %d.", template.getMinSdk());
                }
                case MISSING_THEME: {
                    return "Selected activity template requires an existing Application Theme";
                }
                case NOTHING_SELECTED: {
                    return "No activity template was selected.";
                }
            }
            throw new IllegalArgumentException(this.name());
        }
    }
}

