/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu.gfxinfohandlers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.gpu.GpuSampler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.GfxinfoHandler;
import com.intellij.util.ThreeState;
import gnu.trove.TLongArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MHandler
implements GfxinfoHandler {
    public static final int MIN_API_LEVEL = 23;
    private static final float NS_TO_MS = 1.0E-6f;
    private Client myClient;
    private ProcessStatReceiver myReceiver = new ProcessStatReceiver();
    private long mySynchronizedIdeTimeMs = -1L;
    private long mySynchronizedHostTimeNs = -1L;
    private boolean myDelimiterAdded = true;
    private boolean myIgnoreInitialSamples = true;

    @Override
    public boolean accept(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "accept"));
        }
        return GpuSampler.decodeApiLevel(client) >= 23;
    }

    @Override
    public void setClient(@Nullable Client client) {
        this.myClient = client;
        this.myReceiver.reset();
        this.mySynchronizedHostTimeNs = -1L;
        this.mySynchronizedIdeTimeMs = -1L;
        this.myDelimiterAdded = true;
        this.myIgnoreInitialSamples = true;
    }

    @Override
    public void sample(@NotNull IDevice device, @NotNull ClientData data, @NotNull TimelineData timeline) throws Exception {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "sample"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "sample"));
        }
        if (timeline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeline", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "sample"));
        }
        int pid = data.getPid();
        this.myReceiver.resetSamples();
        device.executeShellCommand("dumpsys gfxinfo " + pid + " framestats", (IShellOutputReceiver)this.myReceiver, 1L, TimeUnit.SECONDS);
        if (this.myIgnoreInitialSamples) {
            this.synchronizeClocks(device);
        }
        if (this.myReceiver.getSampleSize() > 0) {
            if (this.myDelimiterAdded) {
                timeline.add(this.mySynchronizedIdeTimeMs + (this.myReceiver.getCurrentSampleFirstFrameTime() - this.mySynchronizedHostTimeNs) / 1000000L, 1, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
                this.myDelimiterAdded = false;
            }
            if (!this.myIgnoreInitialSamples) {
                for (int i = 0; i < this.myReceiver.getSampleSize(); ++i) {
                    long sampleTime = this.mySynchronizedIdeTimeMs + (this.myReceiver.getEndTime(i) - this.mySynchronizedHostTimeNs) / 1000000L;
                    timeline.add(sampleTime, 1, new float[]{(float)this.myReceiver.getVSyncDelay(i) * 1.0E-6f, (float)this.myReceiver.getInputHandlingTime(i) * 1.0E-6f, (float)this.myReceiver.getAnimationTime(i) * 1.0E-6f, (float)this.myReceiver.getTraversalTime(i) * 1.0E-6f, (float)this.myReceiver.getDrawTime(i) * 1.0E-6f, (float)this.myReceiver.getSyncTime(i) * 1.0E-6f, (float)this.myReceiver.getCommandIssueTime(i) * 1.0E-6f, (float)this.myReceiver.getSwapBufferTime(i) * 1.0E-6f, (float)this.myReceiver.getRemainderTime(i) * 1.0E-6f});
                }
            }
            this.myIgnoreInitialSamples = false;
        } else if (!this.myDelimiterAdded || this.myIgnoreInitialSamples) {
            timeline.add(this.mySynchronizedIdeTimeMs + (this.myReceiver.getLastSampleEndTime() - this.mySynchronizedHostTimeNs) / 1000000L, 1, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
            this.myDelimiterAdded = true;
            this.myIgnoreInitialSamples = false;
        } else {
            this.synchronizeClocks(device);
        }
    }

    @Override
    @NotNull
    public TimelineData createTimelineData() {
        TimelineData timelineData = new TimelineData(9, 8192);
        if (timelineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "createTimelineData"));
        }
        return timelineData;
    }

    @Override
    public ThreeState getIsEnabledOnDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "getIsEnabledOnDevice"));
        }
        return ThreeState.YES;
    }

    private void synchronizeClocks(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler", "synchronizeClocks"));
        }
        assert (this.myClient != null);
        HostNanotimeReceiver hostNanotimeReceiver = new HostNanotimeReceiver();
        for (int i = 0; i < 3; ++i) {
            try {
                this.mySynchronizedIdeTimeMs = System.currentTimeMillis();
                device.executeShellCommand("cat /proc/timer_list", (IShellOutputReceiver)hostNanotimeReceiver, 1L, TimeUnit.SECONDS);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        this.mySynchronizedHostTimeNs = hostNanotimeReceiver.getCurrentSystemTimeNs();
        if (this.mySynchronizedHostTimeNs < 0L) {
            throw new RuntimeException("Could not synchronize time with the device.");
        }
    }

    private static final class HostNanotimeReceiver
    extends MultiLineReceiver {
        static final Pattern myCurrentTimePattern = Pattern.compile("^now at (\\d+) nsecs$");
        private long myCurrentSystemTimeNs = -1L;

        private HostNanotimeReceiver() {
        }

        public long getCurrentSystemTimeNs() {
            return this.myCurrentSystemTimeNs;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher matcher;
                if (this.myCurrentSystemTimeNs >= 0L || !(matcher = myCurrentTimePattern.matcher(line)).find()) continue;
                this.myCurrentSystemTimeNs = Long.parseLong(matcher.group(1));
                return;
            }
        }

        public boolean isCancelled() {
            return this.myCurrentSystemTimeNs >= 0L;
        }
    }

    private static final class ProcessStatReceiver
    extends MultiLineReceiver {
        private long myLastSampleEndTime;
        private long myCurrentSampleFirstFrameTime;
        private TLongArrayList myEndTimes = new TLongArrayList();
        private TLongArrayList myVSyncDelays = new TLongArrayList();
        private TLongArrayList myInputHandlingTimes = new TLongArrayList();
        private TLongArrayList myAnimationTimes = new TLongArrayList();
        private TLongArrayList myTraversalTimes = new TLongArrayList();
        private TLongArrayList myDrawTimes = new TLongArrayList();
        private TLongArrayList mySyncTimes = new TLongArrayList();
        private TLongArrayList myCommandIssueTimes = new TLongArrayList();
        private TLongArrayList mySwapBufferTimes = new TLongArrayList();
        private TLongArrayList myRemainingTimes = new TLongArrayList();
        private boolean myFoundProfileSection = false;
        private boolean myInTimingSection = false;

        public ProcessStatReceiver() {
            this.reset();
        }

        public void reset() {
            this.myLastSampleEndTime = 0L;
            this.myFoundProfileSection = false;
            this.myInTimingSection = false;
            this.resetSamples();
        }

        public void resetSamples() {
            this.myCurrentSampleFirstFrameTime = Long.MAX_VALUE;
            this.myEndTimes.resetQuick();
            this.myVSyncDelays.resetQuick();
            this.myInputHandlingTimes.resetQuick();
            this.myAnimationTimes.resetQuick();
            this.myTraversalTimes.resetQuick();
            this.myDrawTimes.resetQuick();
            this.mySyncTimes.resetQuick();
            this.myCommandIssueTimes.resetQuick();
            this.mySwapBufferTimes.resetQuick();
            this.myRemainingTimes.resetQuick();
        }

        public long getCurrentSampleFirstFrameTime() {
            return this.myCurrentSampleFirstFrameTime;
        }

        public int getSampleSize() {
            return this.mySwapBufferTimes.size();
        }

        public long getLastSampleEndTime() {
            return this.myLastSampleEndTime;
        }

        public long getEndTime(int index) {
            return this.myEndTimes.get(index);
        }

        public long getVSyncDelay(int index) {
            return this.myVSyncDelays.get(index);
        }

        public long getInputHandlingTime(int index) {
            return this.myInputHandlingTimes.get(index);
        }

        public long getAnimationTime(int index) {
            return this.myAnimationTimes.get(index);
        }

        public long getTraversalTime(int index) {
            return this.myTraversalTimes.get(index);
        }

        public long getDrawTime(int index) {
            return this.myDrawTimes.get(index);
        }

        public long getSyncTime(int index) {
            return this.mySyncTimes.get(index);
        }

        public long getCommandIssueTime(int index) {
            return this.myCommandIssueTimes.get(index);
        }

        public long getSwapBufferTime(int index) {
            return this.mySwapBufferTimes.get(index);
        }

        public long getRemainderTime(int index) {
            return this.myRemainingTimes.get(index);
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(@NotNull String[] lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/MHandler$ProcessStatReceiver", "processNewLines"));
            }
            for (String line : lines) {
                String[] timings;
                if (!this.myFoundProfileSection) {
                    if (!line.startsWith("Profile data in ms:")) continue;
                    this.myFoundProfileSection = true;
                    continue;
                }
                if (line.startsWith("---PROFILEDATA---")) {
                    this.myInTimingSection ^= true;
                    continue;
                }
                if (!this.myInTimingSection || (timings = line.split(",")).length != 14) continue;
                try {
                    long flags = Long.parseLong(timings[0]);
                    long endTime = Long.parseLong(timings[12]);
                    if (flags != 0L || endTime <= this.myLastSampleEndTime) continue;
                    long intendedVSyncStart = Long.parseLong(timings[1]);
                    long vSyncStart = Long.parseLong(timings[2]);
                    long handleInputStart = Long.parseLong(timings[5]);
                    long animationStart = Long.parseLong(timings[6]);
                    long traversalsStart = Long.parseLong(timings[7]);
                    long drawStart = Long.parseLong(timings[8]);
                    long syncStart = Long.parseLong(timings[9]);
                    long commandIssueStart = Long.parseLong(timings[10]);
                    long swapStart = Long.parseLong(timings[11]);
                    this.myVSyncDelays.add(vSyncStart - intendedVSyncStart);
                    this.myInputHandlingTimes.add(animationStart - handleInputStart);
                    this.myAnimationTimes.add(traversalsStart - animationStart);
                    this.myTraversalTimes.add(drawStart - traversalsStart);
                    this.myDrawTimes.add(syncStart - drawStart);
                    this.mySyncTimes.add(commandIssueStart - syncStart);
                    this.myCommandIssueTimes.add(swapStart - commandIssueStart);
                    this.mySwapBufferTimes.add(endTime - swapStart);
                    this.myEndTimes.add(endTime);
                    this.myRemainingTimes.add(handleInputStart - vSyncStart);
                    this.myCurrentSampleFirstFrameTime = Math.min(this.myCurrentSampleFirstFrameTime, intendedVSyncStart);
                    this.myLastSampleEndTime = Math.max(this.myLastSampleEndTime, endTime);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

