/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.proguard.psi;

import com.android.tools.idea.lang.proguard.psi.ProguardElementType;
import com.android.tools.idea.lang.proguard.psi.ProguardTokenType;
import com.android.tools.idea.lang.proguard.psi.impl.ProguardCommentImpl;
import com.android.tools.idea.lang.proguard.psi.impl.ProguardFlagImpl;
import com.android.tools.idea.lang.proguard.psi.impl.ProguardJavaSectionImpl;
import com.android.tools.idea.lang.proguard.psi.impl.ProguardMultiLineFlagImpl;
import com.android.tools.idea.lang.proguard.psi.impl.ProguardSingleLineFlagImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface ProguardTypes {
    public static final IElementType COMMENT = new ProguardElementType("COMMENT");
    public static final IElementType FLAG = new ProguardElementType("FLAG");
    public static final IElementType JAVA_SECTION = new ProguardElementType("JAVA_SECTION");
    public static final IElementType MULTI_LINE_FLAG = new ProguardElementType("MULTI_LINE_FLAG");
    public static final IElementType SINGLE_LINE_FLAG = new ProguardElementType("SINGLE_LINE_FLAG");
    public static final IElementType CLOSE_BRACE = new ProguardTokenType("CLOSE_BRACE");
    public static final IElementType CRLF = new ProguardTokenType("CRLF");
    public static final IElementType FLAG_ARG = new ProguardTokenType("FLAG_ARG");
    public static final IElementType FLAG_NAME = new ProguardTokenType("FLAG_NAME");
    public static final IElementType JAVA_DECL = new ProguardTokenType("JAVA_DECL");
    public static final IElementType LINE_CMT = new ProguardTokenType("LINE_CMT");
    public static final IElementType OPEN_BRACE = new ProguardTokenType("OPEN_BRACE");
    public static final IElementType WS = new ProguardTokenType("WS");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == COMMENT) {
                return new ProguardCommentImpl(node);
            }
            if (type == FLAG) {
                return new ProguardFlagImpl(node);
            }
            if (type == JAVA_SECTION) {
                return new ProguardJavaSectionImpl(node);
            }
            if (type == MULTI_LINE_FLAG) {
                return new ProguardMultiLineFlagImpl(node);
            }
            if (type == SINGLE_LINE_FLAG) {
                return new ProguardSingleLineFlagImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

