/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JCenterRepository
extends ArtifactRepository {
    @Override
    @NotNull
    public String getName() {
        if ("JCenter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository", "getName"));
        }
        return "JCenter";
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository", "doSearch"));
        }
        String url = JCenterRepository.createRequestUrl(request);
        SearchResult searchResult = (SearchResult)HttpRequests.request((String)url).accept("application/json").connect(request1 -> this.parse(request1.getReader()));
        if (searchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository", "doSearch"));
        }
        return searchResult;
    }

    @VisibleForTesting
    @NotNull
    static String createRequestUrl(SearchRequest request) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("https://api.bintray.com/search/packages/maven?");
        String groupId = request.getGroupId();
        if (StringUtil.isNotEmpty((String)groupId)) {
            buffer.append("g=").append(groupId).append("&");
        }
        buffer.append("a=").append(request.getArtifactName()).append("&subject=bintray&repo=jcenter");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository", "createRequestUrl"));
        }
        return string;
    }

    SearchResult parse(@NotNull Reader response) {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository", "parse"));
        }
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(response).getAsJsonArray();
        int totalFound = array.size();
        ArrayList artifacts = Lists.newArrayListWithExpectedSize((int)totalFound);
        for (int i = 0; i < totalFound; ++i) {
            JsonObject root = array.get(i).getAsJsonObject();
            String name = root.getAsJsonPrimitive("name").getAsString();
            ArrayList availableVersions = Lists.newArrayList();
            JsonArray versions = root.getAsJsonArray("versions");
            versions.forEach(element -> {
                String version = element.getAsString();
                availableVersions.add(GradleVersion.parse((String)version));
            });
            List coordinate = Splitter.on((String)":").splitToList((CharSequence)name);
            assert (coordinate.size() == 2);
            artifacts.add(new FoundArtifact(this.getName(), (String)coordinate.get(0), (String)coordinate.get(1), availableVersions));
        }
        return new SearchResult(this.getName(), artifacts, totalFound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 1;
    }
}

