/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsVariantCollection
implements PsModelCollection<PsVariant> {
    @NotNull
    private final Map<String, PsVariant> myVariantsByName;

    PsVariantCollection(@NotNull PsAndroidModule parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsVariantCollection", "<init>"));
        }
        this.myVariantsByName = Maps.newHashMap();
        Collection resolvedVariants = parent.getGradleModel().getAndroidProject().getVariants();
        for (Variant resolvedVariant : resolvedVariants) {
            ArrayList productFlavors = Lists.newArrayList();
            for (String productFlavorName : resolvedVariant.getProductFlavors()) {
                PsProductFlavor productFlavor = parent.findProductFlavor(productFlavorName);
                if (productFlavor == null) continue;
                productFlavors.add(productFlavor.getName());
            }
            String buildType = resolvedVariant.getBuildType();
            PsVariant variant = new PsVariant(parent, resolvedVariant.getName(), buildType, productFlavors, resolvedVariant);
            this.myVariantsByName.put(resolvedVariant.getName(), variant);
        }
    }

    @Override
    @Nullable
    public <S extends PsVariant> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsVariantCollection", "findElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/android/PsVariantCollection", "findElement"));
        }
        PsVariant found = this.myVariantsByName.get(name);
        return (S)(type.isInstance(found) ? (PsVariant)type.cast(found) : null);
    }

    @Override
    public void forEach(@NotNull Consumer<PsVariant> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsVariantCollection", "forEach"));
        }
        this.myVariantsByName.values().forEach(consumer);
    }
}

