/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifactCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import icons.AndroidIcons;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsVariant
extends PsChildModel
implements PsAndroidModel {
    @NotNull
    private final String myName;
    @NotNull
    private final String myBuildType;
    @NotNull
    private final List<String> myProductFlavors;
    @Nullable
    private final Variant myResolvedModel;
    private PsAndroidArtifactCollection myArtifactCollection;

    public PsVariant(@NotNull PsAndroidModule parent, @NotNull String name, @NotNull String buildType, @NotNull List<String> productFlavors, @Nullable Variant resolvedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "<init>"));
        }
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "<init>"));
        }
        if (productFlavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productFlavors", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "<init>"));
        }
        super(parent);
        this.myName = name;
        this.myBuildType = buildType;
        this.myProductFlavors = productFlavors;
        this.myResolvedModel = resolvedModel;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        AndroidGradleModel androidGradleModel = this.getParent().getGradleModel();
        if (androidGradleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getGradleModel"));
        }
        return androidGradleModel;
    }

    @Override
    @NotNull
    public PsAndroidModule getParent() {
        PsAndroidModule psAndroidModule = (PsAndroidModule)super.getParent();
        if (psAndroidModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getParent"));
        }
        return psAndroidModule;
    }

    @Nullable
    public Variant getResolvedModel() {
        return this.myResolvedModel;
    }

    @NotNull
    public PsBuildType getBuildType() {
        PsBuildType buildType = this.getParent().findBuildType(this.myBuildType);
        assert (buildType != null);
        PsBuildType psBuildType = buildType;
        if (psBuildType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getBuildType"));
        }
        return psBuildType;
    }

    @Nullable
    public PsAndroidArtifact findArtifact(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "findArtifact"));
        }
        return this.getOrCreateArtifactCollection().findElement(name, PsAndroidArtifact.class);
    }

    public void forEachArtifact(@NotNull Consumer<PsAndroidArtifact> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "forEachArtifact"));
        }
        this.getOrCreateArtifactCollection().forEach(consumer);
    }

    @NotNull
    private PsAndroidArtifactCollection getOrCreateArtifactCollection() {
        PsAndroidArtifactCollection psAndroidArtifactCollection = this.myArtifactCollection == null ? (this.myArtifactCollection = new PsAndroidArtifactCollection(this)) : this.myArtifactCollection;
        if (psAndroidArtifactCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getOrCreateArtifactCollection"));
        }
        return psAndroidArtifactCollection;
    }

    public void forEachProductFlavor(@NotNull Consumer<PsProductFlavor> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "forEachProductFlavor"));
        }
        PsAndroidModule module = this.getParent();
        for (String name : this.myProductFlavors) {
            PsProductFlavor productFlavor = module.findProductFlavor(name);
            consumer.accept(productFlavor);
        }
    }

    @NotNull
    public List<String> getProductFlavors() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myProductFlavors);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsVariant", "getProductFlavors"));
        }
        return immutableList;
    }

    @Override
    public boolean isDeclared() {
        return false;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsVariant that = (PsVariant)o;
        return Objects.equal((Object)this.myName, (Object)that.myName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myName});
    }
}

