/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsProductFlavorCollection
implements PsModelCollection<PsProductFlavor> {
    @NotNull
    private final Map<String, PsProductFlavor> myProductFlavorsByName = Maps.newHashMap();

    PsProductFlavorCollection(PsAndroidModule parent) {
        HashMap productFlavorsFromGradle = Maps.newHashMap();
        for (ProductFlavorContainer container : parent.getGradleModel().getAndroidProject().getProductFlavors()) {
            Object productFlavor = container.getProductFlavor();
            productFlavorsFromGradle.put(productFlavor.getName(), productFlavor);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null) {
            Collection<ProductFlavorModel> parsedProductFlavors = parsedModel.android().productFlavors();
            for (ProductFlavorModel parsedProductFlavor : parsedProductFlavors) {
                String name = parsedProductFlavor.name();
                ProductFlavor fromGradle = (ProductFlavor)productFlavorsFromGradle.remove(name);
                PsProductFlavor model = new PsProductFlavor(parent, fromGradle, parsedProductFlavor);
                this.myProductFlavorsByName.put(name, model);
            }
        }
        if (!productFlavorsFromGradle.isEmpty()) {
            for (Object productFlavor : productFlavorsFromGradle.values()) {
                PsProductFlavor model = new PsProductFlavor(parent, (ProductFlavor)productFlavor, null);
                this.myProductFlavorsByName.put(productFlavor.getName(), model);
            }
        }
    }

    @Override
    public void forEach(@NotNull Consumer<PsProductFlavor> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsProductFlavorCollection", "forEach"));
        }
        this.myProductFlavorsByName.values().forEach(consumer);
    }

    @Override
    @Nullable
    public <S extends PsProductFlavor> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsProductFlavorCollection", "findElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/android/PsProductFlavorCollection", "findElement"));
        }
        if (PsProductFlavor.class.equals(type)) {
            return (S)((PsProductFlavor)type.cast(this.myProductFlavorsByName.get(name)));
        }
        return null;
    }
}

