/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsLibraryDependency
extends PsBaseDependency {
    @NotNull
    public PsModule getParent();

    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec();

    public boolean hasPromotedVersion();

    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies();

    default public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/structure/model/PsLibraryDependency", "setVersion"));
        }
        boolean modified = false;
        ArtifactDependencyModel reference = null;
        for (DependencyModel parsedDependency : this.getParsedModels()) {
            if (!(parsedDependency instanceof ArtifactDependencyModel)) continue;
            ArtifactDependencyModel dependency = (ArtifactDependencyModel)parsedDependency;
            dependency.setVersion(version);
            if (reference == null) {
                reference = dependency;
            }
            modified = true;
        }
        if (modified) {
            GradleVersion parsedVersion = GradleVersion.parse((String)version);
            PsArtifactDependencySpec resolvedSpec = this.getResolvedSpec();
            String resolvedVersion = Strings.nullToEmpty((String)resolvedSpec.version);
            if (parsedVersion.compareTo(resolvedVersion) != 0) {
                resolvedSpec = new PsArtifactDependencySpec(resolvedSpec.name, resolvedSpec.group, version);
                this.setResolvedSpec(resolvedSpec);
            }
            this.setDeclaredSpec(this.createSpec(reference));
            this.setModified(true);
            this.getParent().fireDependencyModifiedEvent((PsDependency)((Object)this));
        }
    }

    @NotNull
    public ImmutableCollection<DependencyModel> getParsedModels();

    @NotNull
    public PsArtifactDependencySpec getResolvedSpec();

    @NotNull
    default public PsArtifactDependencySpec createSpec(@NotNull ArtifactDependencyModel parsedModel) {
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/model/PsLibraryDependency", "createSpec"));
        }
        String compactNotation = parsedModel.compactNotation().value();
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(compactNotation);
        if (!1.$assertionsDisabled && spec == null) {
            throw new AssertionError();
        }
        PsArtifactDependencySpec psArtifactDependencySpec = spec;
        if (psArtifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsLibraryDependency", "createSpec"));
        }
        return psArtifactDependencySpec;
    }

    public void setResolvedSpec(@NotNull PsArtifactDependencySpec var1);

    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec var1);

    public void setModified(boolean var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

