/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.dependencies.android.Configuration;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigurationsPanel
extends JPanel {
    @NotNull
    private final List<Configuration> mySelectedConfigurations;
    @NotNull
    private final PsCheckBoxList<Configuration> myConfigurationsList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<Configuration>> myEventDispatcher = new SelectionChangeEventDispatcher();

    ConfigurationsPanel() {
        super(new BorderLayout());
        ArrayList configurations = Lists.newArrayList((Object[])new Configuration[]{Configuration.MAIN, Configuration.ANDROID_TEST, Configuration.UNIT_TEST});
        this.myConfigurationsList = new PsCheckBoxList(configurations);
        this.mySelectedConfigurations = Lists.newArrayList((Object[])new Configuration[]{Configuration.MAIN});
        for (Configuration configuration : configurations) {
            this.myConfigurationsList.setItemSelected(configuration, true);
        }
        this.myConfigurationsList.addCheckBoxListListener((index, value) -> {
            Configuration configuration = (Configuration)this.myConfigurationsList.getItemAt(index);
            if (configuration != null) {
                if (configuration == Configuration.MAIN) {
                    if (value) {
                        this.myConfigurationsList.setItemSelected(Configuration.ANDROID_TEST, true);
                        this.myConfigurationsList.setItemSelected(Configuration.UNIT_TEST, true);
                    }
                } else if (!value) {
                    this.myConfigurationsList.setItemSelected(Configuration.MAIN, false);
                }
            }
            this.updateSelection();
        });
        this.myConfigurationsList.setSelectionChangeListener(newSelection -> this.updateSelection());
        new ListSpeedSearch(this.myConfigurationsList);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myConfigurationsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)13));
        this.add((Component)scrollPane, "Center");
    }

    private void updateSelection() {
        this.mySelectedConfigurations.clear();
        if (this.myConfigurationsList.isItemSelected(Configuration.MAIN)) {
            this.mySelectedConfigurations.add(Configuration.MAIN);
        } else {
            if (this.myConfigurationsList.isItemSelected(Configuration.ANDROID_TEST)) {
                this.mySelectedConfigurations.add(Configuration.ANDROID_TEST);
            }
            if (this.myConfigurationsList.isItemSelected(Configuration.UNIT_TEST)) {
                this.mySelectedConfigurations.add(Configuration.UNIT_TEST);
            }
        }
        this.myEventDispatcher.selectionChanged(this.mySelectedConfigurations);
    }

    void add(@NotNull SelectionChangeListener<List<Configuration>> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/dependencies/android/ConfigurationsPanel", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/dependencies/android/ConfigurationsPanel", "add"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    @Nullable
    JComponent getPreferredFocusedComponent() {
        return this.myConfigurationsList;
    }

    @NotNull
    List<Configuration> getSelectedConfigurations() {
        List<Configuration> list = this.mySelectedConfigurations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/android/ConfigurationsPanel", "getSelectedConfigurations"));
        }
        return list;
    }
}

