/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

class BuildTypesPanel
extends JPanel {
    @NotNull
    private final PsCheckBoxList<PsBuildType> myBuildTypesList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<PsBuildType>> myEventDispatcher;

    BuildTypesPanel(@NotNull List<PsBuildType> buildTypes) {
        if (buildTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypes", "com/android/tools/idea/gradle/structure/dependencies/android/BuildTypesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        ArrayList items = Lists.newArrayList(buildTypes);
        this.myBuildTypesList = new PsCheckBoxList(items);
        this.myBuildTypesList.setSelectionChangeListener(this.myEventDispatcher::selectionChanged);
        this.myBuildTypesList.setItemsSelected(true);
        new ListSpeedSearch(this.myBuildTypesList);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myBuildTypesList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)12));
        this.add((Component)scrollPane, "Center");
    }

    @NotNull
    List<PsBuildType> getSelectedBuildTypes() {
        ImmutableList<PsBuildType> immutableList = this.myBuildTypesList.getSelectedItems();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/android/BuildTypesPanel", "getSelectedBuildTypes"));
        }
        return immutableList;
    }

    void add(@NotNull SelectionChangeListener<List<PsBuildType>> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/dependencies/android/BuildTypesPanel", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/dependencies/android/BuildTypesPanel", "add"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        PsCheckBoxList<PsBuildType> psCheckBoxList = this.myBuildTypesList;
        if (psCheckBoxList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/android/BuildTypesPanel", "getPreferredFocusedComponent"));
        }
        return psCheckBoxList;
    }
}

