/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidModuleAnalyzer
extends PsModuleAnalyzer<PsAndroidModule> {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    public PsAndroidModuleAnalyzer(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "<init>"));
        }
        super(context);
    }

    @Override
    protected void doAnalyze(@NotNull PsAndroidModule module, @NotNull PsIssueCollection issueCollection) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "doAnalyze"));
        }
        if (issueCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issueCollection", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "doAnalyze"));
        }
        ArrayListMultimap issuesByData = ArrayListMultimap.create();
        AndroidGradleModel gradleModel = module.getGradleModel();
        Collection syncIssues = gradleModel.getAndroidProject().getSyncIssues();
        for (SyncIssue syncIssue : syncIssues) {
            String data = Strings.nullToEmpty((String)syncIssue.getData());
            issuesByData.put((Object)data, (Object)syncIssue);
        }
        PsModulePath modulePath = new PsModulePath(module);
        module.forEachDependency(arg_0 -> this.lambda$doAnalyze$0((Multimap)issuesByData, modulePath, issueCollection, arg_0));
    }

    @VisibleForTesting
    @NotNull
    static PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path, @Nullable PsPath extraPath) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "createIssueFrom"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "createIssueFrom"));
        }
        String message = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message);
        boolean result = matcher.find();
        while (result) {
            String url = matcher.group();
            message = message.replace(url, "<a href='" + url + "'>" + url + "</a>");
            result = matcher.find();
        }
        PsIssue issue = new PsIssue(message, path, PsIssueType.PROJECT_ANALYSIS, PsAndroidModuleAnalyzer.getSeverity(syncIssue));
        issue.setExtraPath(extraPath);
        PsIssue psIssue = issue;
        if (psIssue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "createIssueFrom"));
        }
        return psIssue;
    }

    @NotNull
    private static PsIssue.Severity getSeverity(@NotNull SyncIssue issue) {
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "getSeverity"));
        }
        int severity = issue.getSeverity();
        switch (severity) {
            case 2: {
                PsIssue.Severity severity2 = PsIssue.Severity.ERROR;
                if (severity2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "getSeverity"));
                }
                return severity2;
            }
            case 1: {
                PsIssue.Severity severity3 = PsIssue.Severity.WARNING;
                if (severity3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "getSeverity"));
                }
                return severity3;
            }
        }
        PsIssue.Severity severity4 = PsIssue.Severity.INFO;
        if (severity4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "getSeverity"));
        }
        return severity4;
    }

    @Override
    @NotNull
    public Class<PsAndroidModule> getSupportedModelType() {
        if (PsAndroidModule.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "getSupportedModelType"));
        }
        return PsAndroidModule.class;
    }

    private /* synthetic */ void lambda$doAnalyze$0(Multimap issuesByData, PsModulePath modulePath, @NotNull PsIssueCollection issueCollection, PsAndroidDependency dependency) {
        if (issueCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issueCollection", "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer", "lambda$doAnalyze$0"));
        }
        if (dependency instanceof PsLibraryDependency && dependency.isDeclared()) {
            PsLibraryDependency libraryDependency = (PsLibraryDependency)((Object)dependency);
            PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(this.getContext(), libraryDependency);
            PsArtifactDependencySpec resolvedSpec = libraryDependency.getResolvedSpec();
            String issueKey = resolvedSpec.group + ":" + resolvedSpec.name;
            Collection librarySyncIssues = issuesByData.get((Object)issueKey);
            for (SyncIssue syncIssue : librarySyncIssues) {
                PsIssue issue = PsAndroidModuleAnalyzer.createIssueFrom(syncIssue, path, modulePath);
                issueCollection.add(issue);
            }
            this.analyzeDeclaredDependency(libraryDependency, modulePath, issueCollection);
        }
    }
}

