/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.util.ui.Header;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ChildFocusWatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeader
extends Header
implements Disposable {
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final ToolWindowAnchor myAnchor;
    private JComponent myPreferredFocusedComponent;
    private AnAction myMinimizeAction;
    private ChildFocusWatcher myFocusWatcher;
    private final EventDispatcher<MinimizeListener> myEventDispatcher;

    @NotNull
    public static ToolWindowHeader createAndAdd(@NotNull String title, @NotNull Icon icon, final @NotNull JComponent parent, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "createAndAdd"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "createAndAdd"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "createAndAdd"));
        }
        LayoutManager layout = parent.getLayout();
        assert (layout instanceof BorderLayout);
        final ToolWindowHeader header = new ToolWindowHeader(title, icon, anchor){

            @Override
            public boolean isActive() {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = focusManager.getFocusOwner();
                return focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, parent);
            }
        };
        parent.add((Component)header, "North");
        MyFocusWatcher focusWatcher = new MyFocusWatcher(parent){

            @Override
            void onFocusChange(FocusEvent event) {
                header.repaint();
            }
        };
        super.setFocusWatcher(focusWatcher);
        ToolWindowHeader toolWindowHeader = header;
        if (toolWindowHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "createAndAdd"));
        }
        return toolWindowHeader;
    }

    private ToolWindowHeader(@NotNull String title, @NotNull Icon icon, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "<init>"));
        }
        super(title);
        this.myEventDispatcher = EventDispatcher.create(MinimizeListener.class);
        this.myIcon = icon;
        this.myAnchor = anchor;
        if (this.myAnchor != null) {
            Icon minimizeIcon = this.myAnchor == ToolWindowAnchor.LEFT ? AllIcons.General.HideLeft : AllIcons.General.HideRight;
            this.myMinimizeAction = new DumbAwareAction("Hide", "", minimizeIcon){

                public void actionPerformed(AnActionEvent e) {
                    ((MinimizeListener)ToolWindowHeader.this.myEventDispatcher.getMulticaster()).minimized();
                }
            };
            this.setAdditionalActions(Lists.newArrayList((Object[])new AnAction[]{this.myMinimizeAction}));
        }
        this.addActivationListener(() -> {
            if (this.myPreferredFocusedComponent != null) {
                this.myPreferredFocusedComponent.requestFocusInWindow();
            }
        }, this);
    }

    @Override
    public void setAdditionalActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "setAdditionalActions"));
        }
        ArrayList allActions = actions;
        if (this.myMinimizeAction != null && !actions.contains(this.myMinimizeAction)) {
            allActions = Lists.newArrayList(actions);
            allActions.add(this.myMinimizeAction);
        }
        super.setAdditionalActions(allActions);
    }

    private void setFocusWatcher(@NotNull ChildFocusWatcher focusWatcher) {
        if (focusWatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusWatcher", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "setFocusWatcher"));
        }
        this.myFocusWatcher = focusWatcher;
    }

    public void setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = preferredFocusedComponent;
    }

    public void dispose() {
        if (this.myFocusWatcher != null) {
            Disposer.dispose((Disposable)this.myFocusWatcher);
        }
    }

    @NotNull
    Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchor;
    }

    public void addMinimizeListener(@NotNull MinimizeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader", "addMinimizeListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    public static interface MinimizeListener
    extends EventListener {
        public void minimized();
    }

    private static abstract class MyFocusWatcher
    extends ChildFocusWatcher {
        MyFocusWatcher(@NotNull JComponent parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowHeader$MyFocusWatcher", "<init>"));
            }
            super(parent);
        }

        protected void onFocusGained(FocusEvent event) {
            this.onFocusChange(event);
        }

        protected void onFocusLost(FocusEvent event) {
            this.onFocusChange(event);
        }

        abstract void onFocusChange(FocusEvent var1);
    }
}

