/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionChangeEventDispatcher<T> {
    @NotNull
    private List<SelectionChangeListener<T>> myListeners = new CopyOnWriteArrayList<SelectionChangeListener<T>>();

    public void addListener(@NotNull SelectionChangeListener<T> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher", "addListener"));
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher", "lambda$addListener$0"));
            }
            this.myListeners.remove(listener);
        });
    }

    public void selectionChanged(@Nullable T newSelection) {
        this.myListeners.forEach(listener -> listener.selectionChanged(newSelection));
    }
}

