/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsCheckBoxList<T>
extends CheckBoxList<T> {
    @NotNull
    private final List<CheckBoxListListener> myListeners;
    @Nullable
    private SelectionChangeListener<ImmutableList<T>> mySelectionChangeListener;

    public PsCheckBoxList(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "<init>"));
        }
        this.myListeners = Lists.newCopyOnWriteArrayList();
        this.setItems(items, null);
        super.setCheckBoxListListener((index, value) -> {
            for (CheckBoxListListener listener : this.myListeners) {
                listener.checkBoxSelectionChanged(index, value);
            }
        });
        this.addCheckBoxListListener((index, value) -> this.fireSelectionChangedEvent());
    }

    @Deprecated
    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        throw new UnsupportedOperationException("Invoke 'setSelectionChangeListener' instead");
    }

    public void addCheckBoxListListener(@NotNull CheckBoxListListener checkBoxListListener) {
        if (checkBoxListListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBoxListListener", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "addCheckBoxListListener"));
        }
        this.myListeners.add(checkBoxListListener);
    }

    @NotNull
    public AnAction createSelectAllAction() {
        AnAction anAction = new AnAction("Select All", "", AllIcons.Actions.Selectall){

            public void actionPerformed(AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(true);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "createSelectAllAction"));
        }
        return anAction;
    }

    @NotNull
    public AnAction createUnselectAllAction() {
        AnAction anAction = new AnAction("Unselect All", "", AllIcons.Actions.Unselectall){

            public void actionPerformed(AnActionEvent e) {
                PsCheckBoxList.this.setItemsSelected(false);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "createUnselectAllAction"));
        }
        return anAction;
    }

    public void setItemsSelected(boolean selected) {
        int itemsCount = this.getItemsCount();
        for (int i = 0; i < itemsCount; ++i) {
            Object item = this.getItemAt(i);
            this.setItemSelected(item, selected);
        }
        this.repaint();
        this.fireSelectionChangedEvent();
    }

    private void fireSelectionChangedEvent() {
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.selectionChanged(this.getSelectedItems());
        }
    }

    @NotNull
    public ImmutableList<T> getSelectedItems() {
        int count = this.getItemsCount();
        if (count == 0) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "getSelectedItems"));
            }
            return immutableList;
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            Object item = this.getItemAt(i);
            if (item == null || !this.isItemSelected(item)) continue;
            listBuilder.add(item);
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/PsCheckBoxList", "getSelectedItems"));
        }
        return immutableList;
    }

    public void setSelectionChangeListener(@Nullable SelectionChangeListener<ImmutableList<T>> listener) {
        this.mySelectionChangeListener = listener;
    }
}

