/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.ui.ModulesComboBoxAction;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMainPanel
extends JPanel
implements Disposable,
Place.Navigator {
    @NotNull
    private final PsProject myProject;
    @NotNull
    private final PsContext myContext;
    private boolean myShowModulesDropDown;
    private JComponent myModulesToolbar;
    private History myHistory;

    protected AbstractMainPanel(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "<init>"));
        }
        this(context, Collections.emptyList());
    }

    protected AbstractMainPanel(@NotNull PsContext context, @NotNull List<PsModule> extraTopModules) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "<init>"));
        }
        if (extraTopModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraTopModules", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myProject = context.getProject();
        this.myContext = context;
        this.myShowModulesDropDown = PsUISettings.getInstance().MODULES_LIST_MINIMIZE;
        if (this.myShowModulesDropDown) {
            this.createAndAddModulesAction(extraTopModules);
        }
        PsUISettings.getInstance().addListener(settings -> {
            if (extraTopModules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraTopModules", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "lambda$new$0"));
            }
            if (settings.MODULES_LIST_MINIMIZE != this.myShowModulesDropDown) {
                this.myShowModulesDropDown = settings.MODULES_LIST_MINIMIZE;
                if (this.myShowModulesDropDown) {
                    this.createAndAddModulesAction(extraTopModules);
                } else {
                    this.removeModulesAction();
                }
            }
        }, this);
    }

    private void createAndAddModulesAction(@NotNull List<PsModule> extraTopModules) {
        if (extraTopModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraTopModules", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "createAndAddModulesAction"));
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new ModulesComboBoxAction(this.myContext, extraTopModules));
        DumbAwareAction restoreModuleListAction = new DumbAwareAction("Restore 'Modules' List", "", AllIcons.Actions.MoveTo2){

            public void actionPerformed(AnActionEvent e) {
                PsUISettings settings = PsUISettings.getInstance();
                settings.MODULES_LIST_MINIMIZE = AbstractMainPanel.this.myShowModulesDropDown = false;
                settings.fireUISettingsChanged();
                AbstractMainPanel.this.removeModulesAction();
            }
        };
        actions.add((AnAction)restoreModuleListAction);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)actions, true);
        this.myModulesToolbar = toolbar.getComponent();
        this.myModulesToolbar.setBorder(IdeBorderFactory.createBorder((int)8));
        this.add((Component)this.myModulesToolbar, "North");
    }

    private void removeModulesAction() {
        if (this.myModulesToolbar != null) {
            this.remove(this.myModulesToolbar);
            this.myModulesToolbar = null;
            UiUtil.revalidateAndRepaint(this);
        }
    }

    @NotNull
    protected PsProject getProject() {
        PsProject psProject = this.myProject;
        if (psProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "getProject"));
        }
        return psProject;
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/AbstractMainPanel", "getContext"));
        }
        return psContext;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }
}

