/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.SingleLibraryDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.DeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.DependencySelection;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.issues.SingleModuleIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DeclaredDependenciesTableView;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeclaredDependenciesPanel
extends AbstractDependenciesPanel
implements DependencySelection {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final DeclaredDependenciesTableModel myDependenciesTableModel;
    @NotNull
    private final DeclaredDependenciesTableView<PsAndroidDependency> myDependenciesTable;
    @NotNull
    private final String myPlaceName;
    @NotNull
    private final SelectionChangeEventDispatcher<PsAndroidDependency> myEventDispatcher;
    private boolean mySkipSelectionChangeNotification;

    DeclaredDependenciesPanel(@NotNull PsAndroidModule module, @NotNull PsContext context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "<init>"));
        }
        super("Declared Dependencies", context, module);
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.myContext = context;
        this.myContext.getAnalyzerDaemon().add((PsModel model) -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "lambda$new$0"));
            }
            if (model == module) {
                UIUtil.invokeLaterIfNeeded(this::updateDetailsAndIssues);
            }
        }, this);
        this.myPlaceName = DeclaredDependenciesPanel.createPlaceName(module.getName());
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new SingleModuleIssuesRenderer()));
        this.myDependenciesTableModel = new DeclaredDependenciesTableModel(module, this.myContext);
        this.myDependenciesTable = new DeclaredDependenciesTableView<PsAndroidDependency>(this.myDependenciesTableModel, this.myContext);
        module.add((PsModule.DependencyChangedEvent event) -> {
            PsDependency dependency;
            this.myDependenciesTableModel.reset();
            PsAndroidDependency toSelect = null;
            if (event instanceof PsModule.LibraryDependencyAddedEvent) {
                this.myDependenciesTable.clearSelection();
                PsArtifactDependencySpec spec = ((PsModule.LibraryDependencyAddedEvent)event).getSpec();
                toSelect = this.myDependenciesTableModel.findDependency(spec);
            } else if (event instanceof PsModule.DependencyModifiedEvent && (dependency = ((PsModule.DependencyModifiedEvent)event).getDependency()) instanceof PsAndroidDependency) {
                toSelect = (PsAndroidDependency)dependency;
            }
            if (toSelect != null) {
                this.myDependenciesTable.setSelection(Collections.singletonList(toSelect));
            }
        }, this);
        ListSelectionListener tableSelectionListener = e -> this.updateDetailsAndIssues();
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.myDependenciesTable.selectFirstRow();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myDependenciesTable);
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.getContentsPanel().add((Component)scrollPane, "Center");
        this.updateTableColumnSizes();
    }

    @NotNull
    private static String createPlaceName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "createPlaceName"));
        }
        String string = "dependencies." + moduleName + ".place";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "createPlaceName"));
        }
        return string;
    }

    private void initializeDependencyDetails() {
        this.addDetails(new SingleLibraryDependencyDetails());
        this.addDetails(new ModuleDependencyDetails(this.getContext(), true));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        DeclaredDependenciesTableView<PsAndroidDependency> declaredDependenciesTableView = this.myDependenciesTable;
        if (declaredDependenciesTableView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "getPreferredFocusedComponent"));
        }
        return declaredDependenciesTableView;
    }

    @Override
    @NotNull
    public String getPlaceName() {
        String string = this.myPlaceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "getPlaceName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions() {
        ArrayList actions = Lists.newArrayList();
        actions.add(new EditDependencyAction());
        ArrayList arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "getExtraToolbarActions"));
        }
        return arrayList;
    }

    void updateTableColumnSizes() {
        this.myDependenciesTable.updateColumnSizes();
    }

    public void dispose() {
        Disposer.dispose(this.myDependenciesTable);
    }

    void add(@NotNull SelectionChangeListener<PsAndroidDependency> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "add"));
        }
        this.myEventDispatcher.addListener(listener, this);
        this.notifySelectionChanged();
    }

    @Override
    @Nullable
    public PsAndroidDependency getSelection() {
        return this.myDependenciesTable.getSelectionIfSingle();
    }

    @Override
    public void setSelection(@Nullable PsAndroidDependency selection) {
        this.mySkipSelectionChangeNotification = true;
        if (selection == null) {
            this.myDependenciesTable.clearSelection();
        } else {
            this.myDependenciesTable.setSelection(Collections.singleton(selection));
        }
        this.updateDetailsAndIssues();
        this.mySkipSelectionChangeNotification = false;
    }

    private void updateDetailsAndIssues() {
        if (!this.mySkipSelectionChangeNotification) {
            this.notifySelectionChanged();
        }
        PsAndroidDependency selected = this.getSelection();
        super.updateDetails(selected);
        this.updateIssues(selected);
        History history = this.getHistory();
        if (history != null) {
            history.pushQueryPlace();
        }
    }

    private void notifySelectionChanged() {
        PsAndroidDependency selected = this.getSelection();
        if (selected != null) {
            this.myEventDispatcher.selectionChanged(selected);
        }
    }

    private void updateIssues(@Nullable PsAndroidDependency selected) {
        List<PsIssue> issues = Collections.emptyList();
        if (selected != null) {
            issues = this.myContext.getAnalyzerDaemon().getIssues().findIssues(selected, null);
        }
        this.displayIssues(issues);
    }

    @Override
    public void selectDependency(@Nullable String dependency) {
        if (StringUtil.isEmpty((String)dependency)) {
            this.myDependenciesTable.requestFocusInWindow();
            this.myDependenciesTable.clearSelection();
            return;
        }
        this.doSelectDependency(dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String pathText;
        Object path;
        if (place != null && (path = place.getPath(this.myPlaceName)) instanceof String && !(pathText = (String)path).isEmpty()) {
            this.doSelectDependency(pathText);
        }
        return ActionCallback.DONE;
    }

    private void doSelectDependency(@NotNull String toSelect) {
        if (toSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DeclaredDependenciesPanel", "doSelectDependency"));
        }
        this.myDependenciesTable.selectDependency(toSelect);
    }

    private class EditDependencyAction
    extends DumbAwareAction {
        EditDependencyAction() {
            super("Edit Dependency...", "", AllIcons.Actions.Edit);
            this.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)DeclaredDependenciesPanel.this.myDependenciesTable));
        }

        public void update(AnActionEvent e) {
            DependencyDetails details = DeclaredDependenciesPanel.this.getCurrentDependencyDetails();
            e.getPresentation().setEnabled(details != null);
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

