/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleDslMethodNotFoundErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        if (firstLine != null && firstLine.startsWith("Gradle DSL method not found")) {
            VirtualFile virtualFile;
            String filePath = notification.getFilePath();
            VirtualFile virtualFile2 = virtualFile = filePath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath) : null;
            if (virtualFile != null && "build.gradle".equals(virtualFile.getName())) {
                NotificationHyperlink gradleSettingsHyperlink = GradleDslMethodNotFoundErrorHandler.getGradleSettingsHyperlink(project);
                NotificationHyperlink applyGradlePluginHyperlink = GradleDslMethodNotFoundErrorHandler.getApplyGradlePluginHyperlink(virtualFile, notification);
                FixAndroidGradlePluginVersionHyperlink upgradeAndroidPluginHyperlink = new FixAndroidGradlePluginVersionHyperlink(false);
                String newMsg = firstLine + "\nPossible causes:<ul>";
                if (!GradleDslMethodNotFoundErrorHandler.gradleModelIsRecent(project)) {
                    newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of the Android Gradle plug-in that does not contain the method (e.g. 'testCompile' was added in 1.1.0).\n", project.getName()) + upgradeAndroidPluginHyperlink.toHtml() + "</li>";
                }
                newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of Gradle that does not contain the method.\n", project.getName()) + gradleSettingsHyperlink.toHtml() + "</li><li>The build file may be missing a Gradle plugin.\n" + applyGradlePluginHyperlink.toHtml() + "</li>";
                String title = String.format("Failed to sync Gradle project '%1$s'", project.getName());
                notification.setTitle(title);
                notification.setMessage(newMsg);
                notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
                GradleDslMethodNotFoundErrorHandler.addNotificationListener(notification, project, gradleSettingsHyperlink, applyGradlePluginHyperlink, upgradeAndroidPluginHyperlink);
            } else if (virtualFile != null && notification.getLine() > 0 && notification.getNavigatable() == null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, notification.getLine() - 1, -1);
                notification.setNavigatable((Navigatable)descriptor);
            } else {
                GradleDslMethodNotFoundErrorHandler.updateNotification(notification, project, error.getMessage(), new NotificationHyperlink[0]);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static NotificationHyperlink getGradleSettingsHyperlink(@NotNull Project project) {
        VirtualFile virtualFile;
        File wrapperPropertiesFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getGradleSettingsHyperlink"));
        }
        if (GradleDslMethodNotFoundErrorHandler.isUsingWrapper(project) && (wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project)) != null && (virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true)) != null) {
            NotificationHyperlink notificationHyperlink = new NotificationHyperlink("open.wrapper.file", "Open Gradle wrapper file"){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler$1", "execute"));
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                }
            };
            if (notificationHyperlink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getGradleSettingsHyperlink"));
            }
            return notificationHyperlink;
        }
        OpenGradleSettingsHyperlink openGradleSettingsHyperlink = new OpenGradleSettingsHyperlink();
        if (openGradleSettingsHyperlink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getGradleSettingsHyperlink"));
        }
        return openGradleSettingsHyperlink;
    }

    private static boolean gradleModelIsRecent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "gradleModelIsRecent"));
        }
        GradleVersion fromBuildFile = GradleUtil.getAndroidGradleModelVersionFromBuildFile(project);
        if (fromBuildFile != null) {
            return fromBuildFile.compareTo("2.2.0") >= 0;
        }
        return false;
    }

    private static boolean isUsingWrapper(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "isUsingWrapper"));
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        return (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
    }

    @NotNull
    private static NotificationHyperlink getApplyGradlePluginHyperlink(final @NotNull VirtualFile virtualFile, final @NotNull NotificationData notification) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getApplyGradlePluginHyperlink"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getApplyGradlePluginHyperlink"));
        }
        NotificationHyperlink notificationHyperlink = new NotificationHyperlink("apply.gradle.plugin", "Apply Gradle plugin"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler$2", "execute"));
                }
                GradleDslMethodNotFoundErrorHandler.openFile(virtualFile, notification, project);
                ActionManager actionManager = ActionManager.getInstance();
                String actionId = "AddGradleDslPluginAction";
                AnAction action = actionManager.getAction(actionId);
                assert (action instanceof AddGradleDslPluginAction);
                AddGradleDslPluginAction addPluginAction = (AddGradleDslPluginAction)action;
                actionManager.tryToExecute((AnAction)addPluginAction, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
            }
        };
        if (notificationHyperlink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "getApplyGradlePluginHyperlink"));
        }
        return notificationHyperlink;
    }

    private static void openFile(@NotNull VirtualFile virtualFile, @NotNull NotificationData notification, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "openFile"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "openFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/GradleDslMethodNotFoundErrorHandler", "openFile"));
        }
        int line = notification.getLine() - 1;
        int column = notification.getColumn() - 1;
        line = line < 0 ? -1 : line;
        column = column < 0 ? -1 : column + 1;
        new OpenFileDescriptor(project, virtualFile, line, column).navigate(true);
    }
}

