/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidGradleModelVersions {
    @NotNull
    private final GradleVersion myCurrent;
    @NotNull
    private final GradleVersion myLatest;
    private final boolean myExperimentalPlugin;

    @Nullable
    static AndroidGradleModelVersions find(@NotNull Project project) {
        AndroidProject androidProject;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "find"));
        }
        Module module = AndroidGradleModelVersions.getAppAndroidModule(project);
        if (module != null && (androidProject = GradleUtil.getAndroidProject(module)) != null) {
            if (GradleUtil.isUsingExperimentalPlugin(module)) {
                GradleVersion current = GradleUtil.getAndroidGradleExperimentalPluginVersionFromBuildFile(project);
                if (current != null) {
                    return new AndroidGradleModelVersions(current, true);
                }
            } else {
                GradleVersion current = GradleVersion.parse((String)androidProject.getModelVersion());
                return new AndroidGradleModelVersions(current, false);
            }
        }
        return null;
    }

    @Nullable
    private static Module getAppAndroidModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "getAppAndroidModule"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidProject androidProject = GradleUtil.getAndroidProject(module);
            if (androidProject == null || androidProject.isLibrary()) continue;
            return module;
        }
        return null;
    }

    private AndroidGradleModelVersions(@NotNull GradleVersion current, boolean experimentalPlugin) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "<init>"));
        }
        this(current, AndroidGradleModelVersions.getLatest(experimentalPlugin), experimentalPlugin);
    }

    @NotNull
    private static GradleVersion getLatest(boolean experimentalPlugin) {
        String latest = experimentalPlugin ? "0.8.0" : "2.2.0";
        GradleVersion gradleVersion = GradleVersion.parse((String)latest);
        if (gradleVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "getLatest"));
        }
        return gradleVersion;
    }

    AndroidGradleModelVersions(@NotNull GradleVersion current, @NotNull GradleVersion latest, boolean experimentalPlugin) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "<init>"));
        }
        if (latest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "latest", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "<init>"));
        }
        this.myCurrent = current;
        this.myLatest = latest;
        this.myExperimentalPlugin = experimentalPlugin;
    }

    @NotNull
    GradleVersion getCurrent() {
        GradleVersion gradleVersion = this.myCurrent;
        if (gradleVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "getCurrent"));
        }
        return gradleVersion;
    }

    @NotNull
    GradleVersion getLatest() {
        GradleVersion gradleVersion = this.myLatest;
        if (gradleVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleModelVersions", "getLatest"));
        }
        return gradleVersion;
    }

    boolean isExperimentalPlugin() {
        return this.myExperimentalPlugin;
    }
}

