/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final Project myProject;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "createNotificationPanel"));
        }
        NotificationPanel oldPanel = (NotificationPanel)((Object)fileEditor.getUserData(this.getKey()));
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        return oldPanel != null && oldPanel.type == newPanelType ? oldPanel : newPanelType.create(this.myProject);
    }

    @NotNull
    private NotificationPanel.Type notificationPanelType() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            NotificationPanel.Type type = NotificationPanel.Type.NONE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (!syncState.areSyncNotificationsEnabled()) {
            NotificationPanel.Type type = NotificationPanel.Type.NONE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        if (syncState.isSyncInProgress()) {
            NotificationPanel.Type type = NotificationPanel.Type.IN_PROGRESS;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        if (Projects.lastGradleSyncFailed(this.myProject)) {
            NotificationPanel.Type type = NotificationPanel.Type.FAILED;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        if (Projects.hasErrors(this.myProject)) {
            NotificationPanel.Type type = NotificationPanel.Type.ERRORS;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        ThreeState gradleSyncNeeded = syncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            NotificationPanel.Type type = NotificationPanel.Type.SYNC_NEEDED;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
            }
            return type;
        }
        NotificationPanel.Type type = NotificationPanel.Type.NONE;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider", "notificationPanelType"));
        }
        return type;
    }

    private static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel", "<init>"));
            }
            super(type, text);
            this.createActionLabel("Try Again", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel", "lambda$new$0"));
                }
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            });
            this.createActionLabel("Open 'Messages' View", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel", "lambda$new$1"));
                }
                ExternalSystemNotificationManager.getInstance((Project)project).openMessageView(GradleUtil.GRADLE_SYSTEM_ID, NotificationSource.PROJECT_SYNC);
            });
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                ShowFilePathAction.openFile((File)logFile);
            });
        }
    }

    private static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel", "<init>"));
            }
            super(type, text);
            this.createActionLabel("Sync Now", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel", "lambda$new$0"));
                }
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            });
        }
    }

    private static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel", "<init>"));
            }
            this.type = type;
            this.setText(text);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$1", "create"));
                    }
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$2", "create"));
                    }
                    NotificationPanel notificationPanel = new NotificationPanel(this, "Gradle project sync in progress...");
                    if (notificationPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$2", "create"));
                    }
                    return notificationPanel;
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$3", "create"));
                    }
                    SyncProblemNotificationPanel syncProblemNotificationPanel = new SyncProblemNotificationPanel(project, this, "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.");
                    if (syncProblemNotificationPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$3", "create"));
                    }
                    return syncProblemNotificationPanel;
                }
            }
            ,
            ERRORS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$4", "create"));
                    }
                    SyncProblemNotificationPanel syncProblemNotificationPanel = new SyncProblemNotificationPanel(project, this, "Gradle project sync completed with some errors. Open the 'Messages' view to see the errors found.");
                    if (syncProblemNotificationPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$4", "create"));
                    }
                    return syncProblemNotificationPanel;
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$5", "create"));
                    }
                    boolean areExternalBuildFilesChanged = (Boolean)GradleSyncState.PROJECT_EXTERNAL_BUILD_FILES_CHANGED.get((UserDataHolder)project, (Object)false);
                    String buildFiles = areExternalBuildFilesChanged ? "External build files" : "Gradle files";
                    StaleGradleModelNotificationPanel staleGradleModelNotificationPanel = new StaleGradleModelNotificationPanel(project, this, buildFiles + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.");
                    if (staleGradleModelNotificationPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$5", "create"));
                    }
                    return staleGradleModelNotificationPanel;
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1);
        }
    }
}

