/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.NewProjects;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import icons.EclipseIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdtImportBuilder
extends ProjectImportBuilder<String> {
    private File mySelectedProject;
    private GradleImport myImporter;
    private final boolean myCreateProject;

    public AdtImportBuilder(boolean createProject) {
        this.myCreateProject = createProject;
    }

    @NotNull
    public String getName() {
        if ("ADT (Eclipse Android)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder", "getName"));
        }
        return "ADT (Eclipse Android)";
    }

    public void setSelectedProject(@NotNull File selectedProject) {
        if (selectedProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProject", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder", "setSelectedProject"));
        }
        this.mySelectedProject = selectedProject;
        List<File> projects = Collections.singletonList(this.mySelectedProject);
        this.myImporter = this.createImporter(projects);
    }

    protected GradleImport createImporter(@NotNull List<File> projects) {
        File wrapper;
        File templates;
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder", "createImporter"));
        }
        GradleImport importer = new GradleImport();
        importer.setImportIntoExisting(!this.myCreateProject);
        if (this.myCreateProject && (templates = TemplateManager.getTemplateRootFolder()) != null && (wrapper = TemplateManager.getWrapperLocation(templates)).exists()) {
            importer.setGradleWrapperLocation(wrapper);
            AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (sdkData != null) {
                importer.setSdkLocation(sdkData.getLocation());
            }
        }
        try {
            importer.importProjects(projects);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return importer;
    }

    @Nullable
    public GradleImport getImporter() {
        return this.myImporter;
    }

    public Icon getIcon() {
        return EclipseIcons.Eclipse;
    }

    @Nullable
    public List<String> getList() {
        return null;
    }

    public boolean isMarked(String element) {
        return false;
    }

    public void setList(List<String> list) throws ConfigurationException {
    }

    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Nullable
    public List<Module> commit(Project project, @Nullable ModifiableModuleModel model, ModulesProvider modulesProvider, @Nullable ModifiableArtifactModel artifactModel) {
        File destDir = Projects.getBaseDirPath(project);
        try {
            boolean ok;
            if (!destDir.exists() && !(ok = destDir.mkdirs())) {
                throw new IOException("Could not create destination directory");
            }
            this.readProjects();
            if (!this.myImporter.getErrors().isEmpty()) {
                return null;
            }
            this.myImporter.exportProject(destDir, true);
            project.getBaseDir().refresh(false, true);
        }
        catch (IOException e) {
            Logger.getInstance(AdtImportBuilder.class).error((Throwable)e);
            return null;
        }
        try {
            NewProjectImportGradleSyncListener callback = new NewProjectImportGradleSyncListener(){

                @Override
                public void syncSucceeded(final @NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder$1", "syncSucceeded"));
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewProjects.activateProjectView(project);
                            AdtImportBuilder.openSummary(project);
                        }
                    });
                }

                @Override
                public void syncFailed(final @NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder$1", "syncFailed"));
                    }
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/eclipse/AdtImportBuilder$1", "syncFailed"));
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
                            AdtImportBuilder.openSummary(project);
                        }
                    });
                }
            };
            GradleProjectImporter importer = GradleProjectImporter.getInstance();
            if (this.myCreateProject) {
                importer.importProject(project.getName(), destDir, true, callback, project, null);
            } else {
                importer.requestProjectSync(project, true, callback);
            }
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
        }
        catch (Throwable e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"ADT Project Import");
        }
        return Collections.emptyList();
    }

    public void readProjects() {
        try {
            this.myImporter.importProjects(Collections.singletonList(this.mySelectedProject));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean validate(@Nullable Project current, Project dest) {
        return super.validate(current, dest);
    }

    private static void openSummary(Project project) {
        VirtualFile summary = project.getBaseDir().findChild("import-summary.txt");
        if (summary != null) {
            TemplateUtils.openEditor(project, summary);
        }
    }

    @Nullable
    public static AdtImportBuilder getBuilder(@Nullable WizardContext context) {
        if (context != null) {
            return (AdtImportBuilder)context.getProjectBuilder();
        }
        return null;
    }
}

