/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.android.AbstractFlavorTypeModel;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTypeModel
extends AbstractFlavorTypeModel {
    @NonNls
    private static final String APPLICATION_ID_SUFFIX = "applicationIdSuffix";
    @NonNls
    private static final String BUILD_CONFIG_FIELD = "buildConfigField";
    @NonNls
    private static final String DEBUGGABLE = "debuggable";
    @NonNls
    private static final String EMBED_MICRO_APP = "embedMicroApp";
    @NonNls
    private static final String JNI_DEBUGGABLE = "jniDebuggable";
    @NonNls
    private static final String MINIFY_ENABLED = "minifyEnabled";
    @NonNls
    private static final String PSEUDO_LOCALES_ENABLED = "pseudoLocalesEnabled";
    @NonNls
    private static final String RENDERSCRIPT_DEBUGGABLE = "renderscriptDebuggable";
    @NonNls
    private static final String RENDERSCRIPT_OPTIM_LEVEL = "renderscriptOptimLevel";
    @NonNls
    private static final String SHRINK_RESOURCES = "shrinkResources";
    @NonNls
    private static final String TEST_COVERAGE_ENABLED = "testCoverageEnabled";
    @NonNls
    private static final String VERSION_NAME_SUFFIX = "versionNameSuffix";
    @NonNls
    private static final String ZIP_ALIGN_ENABLED = "zipAlignEnabled";

    public BuildTypeModel(@NotNull BuildTypeDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "<init>"));
        }
        super(dslElement);
    }

    @Nullable
    public String applicationIdSuffix() {
        return this.myDslElement.getProperty(APPLICATION_ID_SUFFIX, String.class);
    }

    @NotNull
    public BuildTypeModel setApplicationIdSuffix(@NotNull String applicationIdSuffix) {
        if (applicationIdSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", APPLICATION_ID_SUFFIX, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setApplicationIdSuffix"));
        }
        this.myDslElement.setNewLiteral(APPLICATION_ID_SUFFIX, applicationIdSuffix);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setApplicationIdSuffix"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeApplicationIdSuffix() {
        this.myDslElement.removeProperty(APPLICATION_ID_SUFFIX);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeApplicationIdSuffix"));
        }
        return buildTypeModel;
    }

    @Nullable
    public List<BuildConfigField> buildConfigFields() {
        List<AbstractFlavorTypeModel.TypeNameValueElement> typeNameValueElements = this.getTypeNameValueElements(BUILD_CONFIG_FIELD);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList buildConfigFields = Lists.newArrayListWithCapacity((int)typeNameValueElements.size());
        for (AbstractFlavorTypeModel.TypeNameValueElement typeNameValueElement : typeNameValueElements) {
            buildConfigFields.add(new BuildConfigField(typeNameValueElement.type(), typeNameValueElement.name(), typeNameValueElement.value()));
        }
        return buildConfigFields;
    }

    @NotNull
    public BuildTypeModel addBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        if (buildConfigField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILD_CONFIG_FIELD, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addBuildConfigField"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.addTypeNameValueElement(buildConfigField);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addBuildConfigField"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        if (buildConfigField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILD_CONFIG_FIELD, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeBuildConfigField"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.removeTypeNameValueElement(buildConfigField);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeBuildConfigField"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeAllBuildConfigFields() {
        this.myDslElement.removeProperty(BUILD_CONFIG_FIELD);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeAllBuildConfigFields"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel replaceBuildConfigField(@NotNull BuildConfigField oldBuildConfigField, @NotNull BuildConfigField newBuildConfigField) {
        if (oldBuildConfigField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBuildConfigField", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceBuildConfigField"));
        }
        if (newBuildConfigField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBuildConfigField", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceBuildConfigField"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.replaceTypeNameValueElement(oldBuildConfigField, newBuildConfigField);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceBuildConfigField"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean debuggable() {
        return this.myDslElement.getProperty(DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setDebuggable(@NotNull Boolean debuggable) {
        if (debuggable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DEBUGGABLE, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setDebuggable"));
        }
        this.myDslElement.setNewLiteral(DEBUGGABLE, debuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setDebuggable"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeDebuggable() {
        this.myDslElement.removeProperty(DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeDebuggable"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean embedMicroApp() {
        return this.myDslElement.getProperty(EMBED_MICRO_APP, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setEmbedMicroApp(@NotNull Boolean embedMicroApp) {
        if (embedMicroApp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EMBED_MICRO_APP, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setEmbedMicroApp"));
        }
        this.myDslElement.setNewLiteral(EMBED_MICRO_APP, embedMicroApp);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setEmbedMicroApp"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeEmbedMicroApp() {
        this.myDslElement.removeProperty(EMBED_MICRO_APP);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeEmbedMicroApp"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean jniDebuggable() {
        return this.myDslElement.getProperty(JNI_DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setJniDebuggable(@NotNull Boolean jniDebuggable) {
        if (jniDebuggable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", JNI_DEBUGGABLE, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setJniDebuggable"));
        }
        this.myDslElement.setNewLiteral(JNI_DEBUGGABLE, jniDebuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setJniDebuggable"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeJniDebuggable() {
        this.myDslElement.removeProperty(JNI_DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeJniDebuggable"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean minifyEnabled() {
        return this.myDslElement.getProperty(MINIFY_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setMinifyEnabled(@NotNull Boolean minifyEnabled) {
        if (minifyEnabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", MINIFY_ENABLED, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setMinifyEnabled"));
        }
        this.myDslElement.setNewLiteral(MINIFY_ENABLED, minifyEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setMinifyEnabled"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeMinifyEnabled() {
        this.myDslElement.removeProperty(MINIFY_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeMinifyEnabled"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean pseudoLocalesEnabled() {
        return this.myDslElement.getProperty(PSEUDO_LOCALES_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setPseudoLocalesEnabled(@NotNull Boolean pseudoLocalesEnabled) {
        if (pseudoLocalesEnabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PSEUDO_LOCALES_ENABLED, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setPseudoLocalesEnabled"));
        }
        this.myDslElement.setNewLiteral(PSEUDO_LOCALES_ENABLED, pseudoLocalesEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setPseudoLocalesEnabled"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removePseudoLocalesEnabled() {
        this.myDslElement.removeProperty(PSEUDO_LOCALES_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removePseudoLocalesEnabled"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean renderscriptDebuggable() {
        return this.myDslElement.getProperty(RENDERSCRIPT_DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setRenderscriptDebuggable(@NotNull Boolean renderscriptDebuggable) {
        if (renderscriptDebuggable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RENDERSCRIPT_DEBUGGABLE, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setRenderscriptDebuggable"));
        }
        this.myDslElement.setNewLiteral(RENDERSCRIPT_DEBUGGABLE, renderscriptDebuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setRenderscriptDebuggable"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptDebuggable() {
        this.myDslElement.removeProperty(RENDERSCRIPT_DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeRenderscriptDebuggable"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Integer renderscriptOptimLevel() {
        return this.myDslElement.getProperty(RENDERSCRIPT_OPTIM_LEVEL, Integer.class);
    }

    @NotNull
    public BuildTypeModel setRenderscriptOptimLevel(@NotNull Integer renderscriptOptimLevel) {
        if (renderscriptOptimLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RENDERSCRIPT_OPTIM_LEVEL, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setRenderscriptOptimLevel"));
        }
        this.myDslElement.setNewLiteral(RENDERSCRIPT_OPTIM_LEVEL, renderscriptOptimLevel);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setRenderscriptOptimLevel"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptOptimLevel() {
        this.myDslElement.removeProperty(RENDERSCRIPT_OPTIM_LEVEL);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeRenderscriptOptimLevel"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean shrinkResources() {
        return this.myDslElement.getProperty(SHRINK_RESOURCES, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setShrinkResources(@NotNull Boolean shrinkResources) {
        if (shrinkResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SHRINK_RESOURCES, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setShrinkResources"));
        }
        this.myDslElement.setNewLiteral(SHRINK_RESOURCES, shrinkResources);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setShrinkResources"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeShrinkResources() {
        this.myDslElement.removeProperty(SHRINK_RESOURCES);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeShrinkResources"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean testCoverageEnabled() {
        return this.myDslElement.getProperty(TEST_COVERAGE_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setTestCoverageEnabled(@NotNull Boolean testCoverageEnabled) {
        if (testCoverageEnabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TEST_COVERAGE_ENABLED, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setTestCoverageEnabled"));
        }
        this.myDslElement.setNewLiteral(TEST_COVERAGE_ENABLED, testCoverageEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setTestCoverageEnabled"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeTestCoverageEnabled() {
        this.myDslElement.removeProperty(TEST_COVERAGE_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeTestCoverageEnabled"));
        }
        return buildTypeModel;
    }

    @Nullable
    public String versionNameSuffix() {
        return this.myDslElement.getProperty(VERSION_NAME_SUFFIX, String.class);
    }

    @NotNull
    public BuildTypeModel setVersionNameSuffix(@NotNull String versionNameSuffix) {
        if (versionNameSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VERSION_NAME_SUFFIX, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setVersionNameSuffix"));
        }
        this.myDslElement.setNewLiteral(VERSION_NAME_SUFFIX, versionNameSuffix);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setVersionNameSuffix"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeVersionNameSuffix() {
        this.myDslElement.removeProperty(VERSION_NAME_SUFFIX);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeVersionNameSuffix"));
        }
        return buildTypeModel;
    }

    @Nullable
    public Boolean zipAlignEnabled() {
        return this.myDslElement.getProperty(ZIP_ALIGN_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setZipAlignEnabled(@NotNull Boolean zipAlignEnabled) {
        if (zipAlignEnabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ZIP_ALIGN_ENABLED, "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setZipAlignEnabled"));
        }
        this.myDslElement.setNewLiteral(ZIP_ALIGN_ENABLED, zipAlignEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setZipAlignEnabled"));
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeZipAlignEnabled() {
        this.myDslElement.removeProperty(ZIP_ALIGN_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeZipAlignEnabled"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addConsumerProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addConsumerProguardFile(consumerProguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addConsumerProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeConsumerProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeConsumerProguardFile(consumerProguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeConsumerProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllConsumerProguardFiles() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllConsumerProguardFiles();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeAllConsumerProguardFiles"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        if (oldConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceConsumerProguardFile"));
        }
        if (newConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceConsumerProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceConsumerProguardFile(oldConsumerProguardFile, newConsumerProguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceConsumerProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setManifestPlaceholder"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeManifestPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeManifestPlaceholder"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeManifestPlaceholder(name);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeManifestPlaceholder"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllManifestPlaceholders() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllManifestPlaceholders();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeAllManifestPlaceholders"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setMultiDexEnabled(boolean multiDexEnabled) {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setMultiDexEnabled(multiDexEnabled);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setMultiDexEnabled"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeMultiDexEnabled() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeMultiDexEnabled();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeMultiDexEnabled"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addProguardFile(proguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeProguardFile(proguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllProguardFiles() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllProguardFiles();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeAllProguardFiles"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        if (oldProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceProguardFile"));
        }
        if (newProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProguardFile", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceProguardFile"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceProguardFile(oldProguardFile, newProguardFile);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceProguardFile"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addResValue"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addResValue(resValue);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "addResValue"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeResValue"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeResValue(resValue);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeResValue"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllResValues() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllResValues();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeAllResValues"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceResValue(@NotNull AbstractFlavorTypeModel.ResValue oldResValue, @NotNull AbstractFlavorTypeModel.ResValue newResValue) {
        if (oldResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldResValue", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceResValue"));
        }
        if (newResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResValue", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceResValue"));
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceResValue(oldResValue, newResValue);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "replaceResValue"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setUseJack(boolean useJack) {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setUseJack(useJack);
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "setUseJack"));
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeUseJack() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeUseJack();
        if (buildTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel", "removeUseJack"));
        }
        return buildTypeModel;
    }

    public static final class BuildConfigField
    extends AbstractFlavorTypeModel.TypeNameValueElement {
        public BuildConfigField(@NotNull String type, @NotNull String name, @NotNull String value) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel$BuildConfigField", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel$BuildConfigField", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel$BuildConfigField", "<init>"));
            }
            super(BuildTypeModel.BUILD_CONFIG_FIELD, type, name, value);
        }
    }
}

