/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Dependency {
    static final List<DependencyScope> SUPPORTED_SCOPES = Lists.newArrayList((Object[])new DependencyScope[]{DependencyScope.COMPILE, DependencyScope.TEST});
    @NotNull
    private DependencyScope myScope;

    Dependency() {
        this(DependencyScope.COMPILE);
    }

    Dependency(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "<init>"));
        }
        this.setScope(scope);
    }

    @NotNull
    public final DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "getScope"));
        }
        return dependencyScope;
    }

    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "setScope"));
        }
        if (!SUPPORTED_SCOPES.contains(scope)) {
            String msg = String.format("'%1$s' is not a supported scope. Supported scopes are %2$s.", scope, SUPPORTED_SCOPES);
            throw new IllegalArgumentException(msg);
        }
        this.myScope = scope;
    }

    @NotNull
    public static DependencySet extractFrom(@NotNull AndroidGradleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "extractFrom"));
        }
        DependencySet dependencies = new DependencySet();
        GradleVersion modelVersion = androidModel.getModelVersion();
        for (BaseArtifact testArtifact : androidModel.getTestArtifactsInSelectedVariant()) {
            Dependency.populate(dependencies, testArtifact, DependencyScope.TEST, modelVersion);
        }
        AndroidArtifact mainArtifact = androidModel.getMainArtifact();
        Dependency.populate(dependencies, (BaseArtifact)mainArtifact, DependencyScope.COMPILE, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "extractFrom"));
        }
        return dependencySet;
    }

    @NotNull
    public static DependencySet extractFrom(@NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "extractFrom"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "extractFrom"));
        }
        DependencySet dependencies = new DependencySet();
        Dependency.populate(dependencies, artifact, scope, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "extractFrom"));
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "populate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "populate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "populate"));
        }
        Dependencies artifactDependencies = GradleUtil.getDependencies(artifact, modelVersion);
        boolean supportsDependencyGraph = modelVersion != null && GradleUtil.androidModelSupportsDependencyGraph(modelVersion);
        Dependency.addJavaLibraries(dependencies, artifactDependencies.getJavaLibraries(), scope, supportsDependencyGraph);
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : artifactDependencies.getLibraries()) {
            Dependency.addAndroidLibrary(library, dependencies, scope, unique, supportsDependencyGraph);
        }
        if (!supportsDependencyGraph) {
            for (String gradleProjectPath : artifactDependencies.getProjects()) {
                if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
                ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
                dependencies.add(dependency);
            }
        }
    }

    @NotNull
    private static String getLibraryName(@NotNull AndroidLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "getLibraryName"));
        }
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null) {
            String string = coordinates.getArtifactId() + "-" + coordinates.getVersion();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "getLibraryName"));
            }
            return string;
        }
        File bundle = library.getBundle();
        String string = FileUtil.getNameWithoutExtension((File)bundle);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "getLibraryName"));
        }
        return string;
    }

    @NotNull
    private static ModuleDependency addAndroidModule(@NotNull AndroidLibrary library, @NotNull String gradleProjectPath, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique, boolean supportsDependencyGraph) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        if (gradleProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProjectPath", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
        dependencies.add(dependency);
        Dependency.addTransitiveDependencies(library, dependencies, scope, unique, supportsDependencyGraph);
        ModuleDependency moduleDependency = dependency;
        if (moduleDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidModule"));
        }
        return moduleDependency;
    }

    private static void addAndroidLibrary(@NotNull AndroidLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique, boolean supportsDependencyGraph) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidLibrary"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidLibrary"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addAndroidLibrary"));
        }
        File folder = library.getFolder();
        if (unique.contains(folder)) {
            return;
        }
        unique.add(folder);
        ModuleDependency mainDependency = null;
        String gradleProjectPath = library.getProject();
        if (StringUtil.isNotEmpty((String)gradleProjectPath)) {
            mainDependency = Dependency.addAndroidModule(library, gradleProjectPath, dependencies, scope, unique, supportsDependencyGraph);
        }
        if (mainDependency == null) {
            dependencies.add(Dependency.createLibraryDependency(library, scope));
            Dependency.addTransitiveDependencies(library, dependencies, scope, unique, supportsDependencyGraph);
        } else {
            LibraryDependency backup = Dependency.createLibraryDependency(library, scope);
            mainDependency.setBackupDependency(backup);
        }
    }

    private static void addTransitiveDependencies(@NotNull AndroidLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique, boolean supportsDependencyGraph) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addTransitiveDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addTransitiveDependencies"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addTransitiveDependencies"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addTransitiveDependencies"));
        }
        for (AndroidLibrary dependentLibrary : library.getLibraryDependencies()) {
            Dependency.addAndroidLibrary(dependentLibrary, dependencies, scope, unique, supportsDependencyGraph);
        }
        if (supportsDependencyGraph) {
            Dependency.addJavaLibraries(dependencies, library.getJavaDependencies(), scope, true);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependency(@NotNull AndroidLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        LibraryDependency dependency = new LibraryDependency(Dependency.getLibraryName(library), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (File localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        VirtualFile sourceJar = GradleUtil.findSourceJarForLibrary(library.getBundle());
        if (sourceJar != null) {
            File sourceJarFile = VfsUtilCore.virtualToIoFile((VirtualFile)sourceJar);
            dependency.addPath(LibraryDependency.PathType.SOURCE, sourceJarFile);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        return libraryDependency;
    }

    private static void addJavaLibraries(@NotNull DependencySet dependencies, @NotNull Collection<? extends JavaLibrary> libraries, @NotNull DependencyScope scope, boolean supportsDependencyGraph) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibraries"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibraries"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibraries"));
        }
        for (JavaLibrary javaLibrary : libraries) {
            if (supportsDependencyGraph) {
                ModuleDependency mainDependency = null;
                String gradleProjectPath = javaLibrary.getProject();
                MavenCoordinates coordinates = javaLibrary.getResolvedCoordinates();
                String classifier = coordinates.getClassifier();
                if (StringUtil.isNotEmpty((String)gradleProjectPath) && StringUtil.isEmpty((String)classifier)) {
                    mainDependency = new ModuleDependency(gradleProjectPath, scope);
                    dependencies.add(mainDependency);
                    Dependency.addJavaLibraries(dependencies, javaLibrary.getDependencies(), scope, true);
                }
                if (mainDependency == null) {
                    Dependency.addJavaLibrary(javaLibrary, dependencies, scope, true);
                    continue;
                }
                LibraryDependency backup = Dependency.createLibraryDependency(javaLibrary, scope);
                mainDependency.setBackupDependency(backup);
                continue;
            }
            Dependency.addJavaLibrary(javaLibrary, dependencies, scope, false);
        }
    }

    private static void addJavaLibrary(@NotNull JavaLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, boolean supportsDependencyGraph) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibrary"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "addJavaLibrary"));
        }
        dependencies.add(Dependency.createLibraryDependency(library, scope));
        Dependency.addJavaLibraries(dependencies, library.getDependencies(), scope, supportsDependencyGraph);
    }

    @NotNull
    private static LibraryDependency createLibraryDependency(@NotNull JavaLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        LibraryDependency libraryDependency = new LibraryDependency(library.getJarFile(), scope);
        if (libraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/dependency/Dependency", "createLibraryDependency"));
        }
        return libraryDependency;
    }
}

