/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.fd.InstantRunConfiguration;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
HyperlinkListener,
GradleSyncListener,
Disposable {
    private final InstantRunConfiguration myBuildConfiguration;
    private JPanel myContentPanel;
    private JBCheckBox myInstantRunCheckBox;
    private JBCheckBox myRestartActivityCheckBox;
    private JBLabel myGradleLabel;
    private HyperlinkLabel myOldVersionLabel;
    private JBCheckBox myShowToastCheckBox;
    private JBCheckBox myShowIrStatusNotifications;

    public InstantRunConfigurable() {
        this.$$$setupUI$$$();
        this.myBuildConfiguration = InstantRunConfiguration.getInstance();
        this.updateLinkState();
    }

    @NotNull
    public String getId() {
        if ("instant.run" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunConfigurable", "getId"));
        }
        return "instant.run";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Instant Run";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myBuildConfiguration.INSTANT_RUN != this.isInstantRunEnabled() || this.myBuildConfiguration.RESTART_ACTIVITY != this.isRestartActivity() || this.myBuildConfiguration.SHOW_TOAST != this.isShowToast() || this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS != this.isShowStatusNotifications();
    }

    public void apply() throws ConfigurationException {
        this.myBuildConfiguration.INSTANT_RUN = this.isInstantRunEnabled();
        this.myBuildConfiguration.RESTART_ACTIVITY = this.isRestartActivity();
        this.myBuildConfiguration.SHOW_TOAST = this.isShowToast();
        this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS = this.isShowStatusNotifications();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault()) continue;
            InstantRunManager.updateFileListener(project);
        }
    }

    public void reset() {
        this.myInstantRunCheckBox.setSelected(this.myBuildConfiguration.INSTANT_RUN);
        this.myRestartActivityCheckBox.setSelected(this.myBuildConfiguration.RESTART_ACTIVITY);
        this.myShowToastCheckBox.setSelected(this.myBuildConfiguration.SHOW_TOAST);
        this.myShowIrStatusNotifications.setSelected(this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS);
    }

    public void disposeUIResources() {
    }

    private boolean isInstantRunEnabled() {
        return this.myInstantRunCheckBox.isSelected();
    }

    private boolean isRestartActivity() {
        return this.myRestartActivityCheckBox.isSelected();
    }

    private boolean isShowToast() {
        return this.myShowToastCheckBox.isSelected();
    }

    private boolean isShowStatusNotifications() {
        return this.myShowIrStatusNotifications.isSelected();
    }

    private void createUIComponents() {
        this.myOldVersionLabel = new HyperlinkLabel();
        this.setSyncLinkMessage("");
        this.myOldVersionLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void setSyncLinkMessage(@NotNull String syncMessage) {
        if (syncMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncMessage", "com/android/tools/idea/fd/InstantRunConfigurable", "setSyncLinkMessage"));
        }
        this.myOldVersionLabel.setHyperlinkText("Instant Run requires a newer version of the Gradle plugin. ", "Update Project", syncMessage);
        this.myOldVersionLabel.repaint();
    }

    private void updateLinkState() {
        boolean isGradle = false;
        boolean isCurrentPlugin = false;
        block0: for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault()) continue;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidGradleModel model = AndroidGradleModel.get(module);
                if (model == null) continue;
                isGradle = true;
                if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) continue;
                isCurrentPlugin = true;
                continue block0;
            }
        }
        this.myGradleLabel.setVisible(!isGradle);
        this.myOldVersionLabel.setVisible(isGradle && !isCurrentPlugin);
        boolean enabled = isGradle && isCurrentPlugin;
        this.myInstantRunCheckBox.setEnabled(isGradle);
        this.myRestartActivityCheckBox.setEnabled(enabled);
        this.myShowToastCheckBox.setEnabled(enabled);
        this.myShowIrStatusNotifications.setEnabled(enabled);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || InstantRunConfigurable.updateProjectToInstantRunTools(project, this)) continue;
            this.setSyncLinkMessage("Error updating to new Gradle version");
        }
    }

    public static boolean updateProjectToInstantRunTools(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunConfigurable", "updateProjectToInstantRunTools"));
        }
        String pluginVersion = "2.2.0";
        if (GradleVersion.parse((String)"2.2.0").compareTo(InstantRunManager.MINIMUM_GRADLE_PLUGIN_VERSION) > 0) {
            pluginVersion = "2.2.0";
        }
        if (GradleUtil.updateGradlePluginVersion(project, pluginVersion, "2.14.1")) {
            Revision revision;
            String buildToolsVersion = "23.0.2";
            AndroidSdkHandler sdk = AndroidSdkUtils.tryToChooseSdkHandler();
            BuildToolInfo latestBuildTool = sdk.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunConfigurable.class), false);
            if (latestBuildTool != null && (revision = latestBuildTool.getRevision()).compareTo(Revision.parseRevision((String)buildToolsVersion)) > 0) {
                buildToolsVersion = revision.toShortString();
            }
            GradleUtil.setBuildToolsVersion(project, buildToolsVersion);
            File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
            if (wrapperPropertiesFile != null) {
                GradleUtil.updateGradleDistributionUrl(project, wrapperPropertiesFile, "2.14.1");
            }
            GradleProjectImporter.getInstance().syncProjectSynchronously(project, true, listener);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunConfigurable", "syncStarted"));
        }
        this.updateUi(true, false);
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunConfigurable", "syncSucceeded"));
        }
        this.updateUi(false, false);
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunConfigurable", "syncFailed"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/fd/InstantRunConfigurable", "syncFailed"));
        }
        this.updateUi(false, true);
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunConfigurable", "syncSkipped"));
        }
        this.updateUi(false, false);
    }

    private void updateUi(final boolean syncing, final boolean failed) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InstantRunConfigurable.this.myContentPanel.isShowing()) {
                    if (syncing) {
                        InstantRunConfigurable.this.setSyncLinkMessage("(Syncing)");
                    } else if (failed) {
                        InstantRunConfigurable.this.setSyncLinkMessage("(Sync Failed)");
                    } else {
                        InstantRunConfigurable.this.setSyncLinkMessage("");
                    }
                    InstantRunConfigurable.this.updateLinkState();
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInstantRunCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Enable Instant Run to hot swap code/resource changes on deploy (default enabled)");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRestartActivityCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Restart activity on code changes");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGradleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Instant Run requires the project to be built with Gradle.");
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myOldVersionLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myShowToastCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show toasts in the running app when changes are applied");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowIrStatusNotifications = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show Instant Run status notifications");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

