/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views.nodedata;

import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapPackageNode;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapClassObjNode
implements HeapNode {
    @Nullable
    private HeapNode myParent;
    @NotNull
    private ClassObj myClassObj;
    private long myRetainedSize;
    private String mySimpleName;

    public HeapClassObjNode(@NotNull ClassObj classObj, int heapId) {
        if (classObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObj", "com/android/tools/idea/editors/hprof/views/nodedata/HeapClassObjNode", "<init>"));
        }
        this.myClassObj = classObj;
        for (Instance instance : this.myClassObj.getHeapInstances(heapId)) {
            this.myRetainedSize += instance.getTotalRetainedSize();
        }
        this.mySimpleName = this.myClassObj.getClassName();
        int index = this.mySimpleName.lastIndexOf(46);
        if (index >= 0 && index < this.mySimpleName.length() - 1) {
            this.mySimpleName = this.mySimpleName.substring(index + 1, this.mySimpleName.length());
        }
    }

    @NotNull
    public ClassObj getClassObj() {
        ClassObj classObj = this.myClassObj;
        if (classObj == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapClassObjNode", "getClassObj"));
        }
        return classObj;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.getClassObj().getClassName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapClassObjNode", "getFullName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        String string = this.mySimpleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapClassObjNode", "getSimpleName"));
        }
        return string;
    }

    @Override
    public int getTotalCount() {
        return this.getClassObj().getInstanceCount();
    }

    @Override
    public int getHeapInstancesCount(int heapId) {
        return this.getClassObj().getHeapInstancesCount(heapId);
    }

    @Override
    public int getInstanceSize() {
        return this.getClassObj().getInstanceSize();
    }

    @Override
    public int getShallowSize(int heapId) {
        return this.getClassObj().getShallowSize(heapId);
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public void add(@NotNull HeapNode heapNode) {
        if (heapNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapNode", "com/android/tools/idea/editors/hprof/views/nodedata/HeapClassObjNode", "add"));
        }
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    @NotNull
    public List<HeapNode> getChildren() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeAllChildren() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            assert (this.myParent instanceof HeapPackageNode);
            ((HeapPackageNode)this.myParent).remove(this);
            this.myParent = null;
        }
    }

    @Override
    public void setParent(@Nullable HeapNode newParent) {
        assert (newParent == null || newParent instanceof HeapPackageNode);
        this.myParent = newParent;
    }
}

