/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview;

import com.android.ddmlib.Client;
import com.android.tools.idea.editors.hierarchyview.HierarchyViewCaptureOptions;
import com.android.tools.idea.editors.hierarchyview.HierarchyViewCaptureType;
import com.android.tools.idea.editors.hierarchyview.model.ClientWindow;
import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class HierarchyViewCaptureTask
extends Task.Backgroundable {
    private static final String TITLE = "Capture View Hierarchy";
    @NotNull
    private final Client myClient;
    @NotNull
    private final ClientWindow myWindow;
    private String myError;
    private byte[] myData;

    public HierarchyViewCaptureTask(@NotNull Project project, @NotNull Client client, @NotNull ClientWindow window) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hierarchyview/HierarchyViewCaptureTask", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/editors/hierarchyview/HierarchyViewCaptureTask", "<init>"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/android/tools/idea/editors/hierarchyview/HierarchyViewCaptureTask", "<init>"));
        }
        super(project, "Capturing View Hierarchy");
        this.myClient = client;
        this.myWindow = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/hierarchyview/HierarchyViewCaptureTask", "run"));
        }
        HierarchyViewCaptureOptions options = new HierarchyViewCaptureOptions();
        options.setTitle(this.myWindow.getDisplayName());
        indicator.setText("Capturing View Hierarchy");
        indicator.setIndeterminate(false);
        byte[] hierarchy = this.myWindow.loadWindowData(20L, TimeUnit.SECONDS);
        if (hierarchy == null) {
            this.myError = "Unexpected error: empty view hierarchy";
            return;
        }
        indicator.setText("Capturing preview");
        indicator.setFraction(0.5);
        ViewNode root = ViewNode.parseFlatString(hierarchy);
        if (root == null) {
            this.myError = "Unable to parse view hierarchy";
            return;
        }
        byte[] preview = this.myWindow.loadViewImage(root, 10L, TimeUnit.SECONDS);
        if (preview == null) {
            this.myError = "Unable to obtain preview image";
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(bytes);
            output.writeUTF(options.toString());
            output.writeInt(hierarchy.length);
            output.write(hierarchy);
            output.writeInt(preview.length);
            output.write(preview);
        }
        catch (IOException e) {
            this.myError = "Unexpected error while saving hierarchy snapshot: " + e;
            return;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                this.myError = "Unexpected error while closing hierarchy snapshot: " + e;
            }
        }
        this.myData = bytes.toByteArray();
    }

    public void onSuccess() {
        if (this.myError != null) {
            Messages.showErrorDialog((String)("Error obtaining view hierarchy: " + StringUtil.notNullize((String)this.myError)), (String)TITLE);
            return;
        }
        CaptureService service = CaptureService.getInstance(this.myProject);
        try {
            Capture capture = service.createCapture(HierarchyViewCaptureType.class, this.myData, service.getSuggestedName(this.myClient));
            final VirtualFile file = capture.getFile();
            file.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OpenFileDescriptor descriptor = new OpenFileDescriptor(HierarchyViewCaptureTask.this.myProject, file);
                            FileEditorManager.getInstance((Project)HierarchyViewCaptureTask.this.myProject).openEditor(descriptor, true);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Error creating hierarchy view capture: " + e), (String)TITLE);
        }
    }
}

