/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer;

import com.android.tools.idea.editors.gfxtrace.viewer.gl.Shader;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.MatD;
import java.util.ArrayDeque;
import java.util.Deque;

public class ModelViewProjection {
    private final boolean myInvertNormals;
    private MatD myModelView = MatD.IDENTITY;
    private MatD myProjection = MatD.IDENTITY;
    private final Deque<MatD> myMatrixStack = new ArrayDeque<MatD>();

    public ModelViewProjection(boolean invertNormals) {
        this.myInvertNormals = invertNormals;
    }

    public void setProjection(MatD projection) {
        this.myProjection = projection;
    }

    public void setModelView(MatD modelView) {
        this.myModelView = modelView;
    }

    public void push(MatD transform) {
        this.myMatrixStack.push(this.myModelView);
        this.myModelView = this.myModelView.multiply(transform);
    }

    public void pop() {
        this.myModelView = this.myMatrixStack.pop();
    }

    public void apply(Shader shader) {
        shader.setUniform("uModelView", this.myModelView.toFloatArray());
        shader.setUniform("uModelViewProj", this.myProjection.multiply(this.myModelView).toFloatArray());
        shader.setUniform("uNormalMatrix", this.myModelView.toNormalMatrix(this.myInvertNormals));
        shader.setUniform("uInvertNormals", Float.valueOf(this.myInvertNormals ? -1.0f : 1.0f));
    }
}

