/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientWrapper;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.rpclib.schema.Message;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.Callable;

public class ServiceClientCache
extends ServiceClientWrapper {
    private static final Logger LOG = Logger.getInstance(ServiceClientCache.class);
    private ListenableFuture<Message> mySchema;
    private final Object mySchemaLock = new Object();
    private final RpcCache<Path, Object> myPathCache;
    private final RpcCache<Path, Path> myFollowCache;

    public ServiceClientCache(final ServiceClient client, ListeningExecutorService executorService) {
        super(client);
        this.myPathCache = new RpcCache<Path, Object>(executorService){

            @Override
            protected ListenableFuture<Object> fetch(Path key) {
                return client.get(key);
            }
        };
        this.myFollowCache = new RpcCache<Path, Path>(executorService){

            @Override
            protected ListenableFuture<Path> fetch(Path key) {
                return client.follow(key);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Message> getSchema() {
        Object object = this.mySchemaLock;
        synchronized (object) {
            if (this.mySchema == null) {
                this.mySchema = this.myClient.getSchema();
            }
        }
        return this.mySchema;
    }

    @Override
    public ListenableFuture<Path> follow(Path p) {
        LOG.debug("Following " + p);
        return this.myFollowCache.get(p);
    }

    @Override
    public ListenableFuture<Object> get(Path p) {
        LOG.debug("Getting " + p);
        return this.myPathCache.get(p);
    }

    private static abstract class RpcCache<K, V> {
        private final Cache<K, V> myCache = CacheBuilder.newBuilder().softValues().build();
        private final ListeningExecutorService myExecutorService;

        public RpcCache(ListeningExecutorService executorService) {
            this.myExecutorService = executorService;
        }

        public ListenableFuture<V> get(final K key) {
            ListenableFuture cacheLookUp = this.myExecutorService.submit(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return myCache.getIfPresent(key);
                }
            });
            return Futures.transform((ListenableFuture)cacheLookUp, (AsyncFunction)new AsyncFunction<V, V>(){
                private boolean alreadyFetching = false;

                public ListenableFuture<V> apply(V result) throws Exception {
                    if (result != null || this.alreadyFetching) {
                        myCache.put(key, result);
                        return Futures.immediateFuture(result);
                    }
                    this.alreadyFetching = true;
                    return Futures.transform(this.fetch(key), (AsyncFunction)this);
                }
            });
        }

        protected abstract ListenableFuture<V> fetch(K var1);
    }
}

