/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.service.Context;
import com.android.tools.idea.editors.gfxtrace.service.ContextList;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.intellij.openapi.ui.ComboBox;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ContextController
extends Controller
implements AtomStream.Listener {
    private final JComboBox myComboBox;
    @NotNull
    private Context mySelectedContext;
    private ContextList myContexts;
    private CapturePath myCapturePath;
    private boolean mySuspendUiUpdates;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new ContextController((GfxTraceEditor)editor).myComboBox;
    }

    private ContextController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        super(editor);
        this.myComboBox = new ComboBox();
        this.mySelectedContext = Context.ALL;
        editor.getAtomStream().addListener(this);
        this.myComboBox.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.selectContext((Context)event.getItem());
            }
        });
    }

    private void selectContext(Context context) {
        if (this.mySuspendUiUpdates || Objects.equals(context, this.mySelectedContext)) {
            return;
        }
        this.mySelectedContext = context;
        if (context != null) {
            this.myEditor.activatePath(this.myCapturePath.contexts().context(context.getID()), this);
        } else {
            this.myEditor.activatePath(this.myCapturePath.contexts(), this);
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    @Override
    public void onAtomLoadingStart(AtomStream atoms) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAtomLoadingComplete(AtomStream atoms) {
        Context contextToSelect;
        if (!atoms.isLoaded()) {
            return;
        }
        this.mySuspendUiUpdates = true;
        try {
            this.myCapturePath = atoms.getPath().getCapture();
            this.myContexts = atoms.getContexts();
            this.myComboBox.removeAllItems();
            if (this.myContexts.count() == 1) {
                contextToSelect = this.myContexts.getContexts()[0];
            } else {
                this.myComboBox.addItem(Context.ALL);
                contextToSelect = this.myContexts.find(this.mySelectedContext.getID(), Context.ALL);
            }
            for (Context context : this.myContexts) {
                this.myComboBox.addItem(context);
            }
            this.myComboBox.setSelectedItem(contextToSelect);
            this.myComboBox.setVisible(this.myContexts.count() > 0);
        }
        finally {
            this.mySuspendUiUpdates = false;
        }
        this.selectContext(contextToSelect);
    }

    @Override
    public void onAtomsSelected(AtomRangePath path) {
    }
}

