/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AtomComboAction
extends FlatComboAction {
    @NotNull
    private final GfxTraceEditor myGfxTraceEditor;
    @NotNull
    private List<Long> myAtomIds;

    public AtomComboAction(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/actions/AtomComboAction", "<init>"));
        }
        this.myAtomIds = Collections.emptyList();
        this.myGfxTraceEditor = editor;
    }

    public void setAtomIds(@NotNull List<Long> atomIds) {
        if (atomIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomIds", "com/android/tools/idea/editors/gfxtrace/actions/AtomComboAction", "setAtomIds"));
        }
        this.myAtomIds = atomIds;
    }

    @Override
    protected FlatComboAction.FlatComboButton createComboBoxButton(@NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/android/tools/idea/editors/gfxtrace/actions/AtomComboAction", "createComboBoxButton"));
        }
        presentation.setIcon(AndroidIcons.GfxTrace.Jump);
        presentation.setDescription("Accesses / Modifications");
        return super.createComboBoxButton(presentation);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (final Long atomIndex : this.myAtomIds) {
            AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (atomIndex != null) {
                        AtomComboAction.this.myGfxTraceEditor.getAtomStream().selectAtoms(atomIndex, 1L, (Object)this);
                    }
                }
            };
            actionGroup.add(action);
            Presentation presentation = action.getTemplatePresentation();
            Atom atom = this.myGfxTraceEditor.getAtomStream().getAtom(atomIndex);
            presentation.setText(atomIndex + ": " + atom.getName());
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/AtomComboAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }
}

