/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.controllers.MainController;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisConnection;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisFeatures;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisProcess;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.models.GpuState;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientCache;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.Info;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.StringTable;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadablePanel;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Message;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor {
    private static final int FETCH_SCHEMA_TIMEOUT_MS = 3000;
    private static final int FETCH_FEATURES_TIMEOUT_MS = 3000;
    private static final int FETCH_STRING_TABLE_TIMEOUT_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_TIMEOUT_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_RETRY_DELAY_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_MAX_RETRIES = 30;
    private static final int FETCH_TRACE_TIMEOUT_MS = 30000;
    @NotNull
    public static final String LOADING_CAPTURE = "Loading capture...";
    @NotNull
    public static final String SELECT_ATOM = "Select a frame or command";
    @NotNull
    public static final String SELECT_DRAW_CALL = "Select a draw call";
    @NotNull
    public static final String SELECT_MEMORY = "Select a memory range or pointer in the command list";
    @NotNull
    public static final String SELECT_TEXTURE = "Select a texture";
    @NotNull
    public static final String NO_TEXTURES = "No textures have been created by this point";
    @NotNull
    public static final String NOTIFICATION_GROUP = "GPU Trace";
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final JBPanel myView;
    @NotNull
    private final LoadablePanel myLoadingPanel;
    @NotNull
    private final ListeningExecutorService myExecutor;
    @NotNull
    private final AtomStream myAtomStream;
    @NotNull
    private final GpuState myState;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final JComponent myMainUi;
    @NotNull
    private final List<PathListener> myPathListeners;
    @NotNull
    private final List<ConnectionListener> myConnectionListeners;
    private final long myStartTime;
    @Nullable
    private GapisConnection myGapisConnection;
    @Nullable
    private ServiceClient myClient;

    public static boolean isEnabled() {
        return true;
    }

    public GfxTraceEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        this.myView = new JBPanel((LayoutManager)new BorderLayout());
        this.myLoadingPanel = new LoadablePanel((JPanel)this.myView);
        this.myExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.myAtomStream = new AtomStream(this);
        this.myState = new GpuState(this);
        this.myPathListeners = new ArrayList<PathListener>();
        this.myConnectionListeners = new ArrayList<ConnectionListener>();
        this.myStartTime = System.currentTimeMillis();
        this.myProject = project;
        this.myFile = file;
        this.myLoadingPanel.setLoadingText("Initializing GFX Trace System");
        GfxTraceUtil.trackEvent("gfxTraceOpened", null, null);
        this.addPathListener(this.myAtomStream);
        this.addPathListener(this.myState);
        this.myMainUi = MainController.createUI(this);
        this.connect();
    }

    public GapisFeatures getFeatures() {
        return this.myGapisConnection.getFeatures();
    }

    private void connect() {
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Collection<String> missingComponents = GapiPaths.getMissingSdkComponents();
                if (!missingComponents.isEmpty()) {
                    HyperlinkLabel link = new HyperlinkLabel("(install here)");
                    link.addHyperlinkListener(e -> {
                        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(GfxTraceEditor.this.myProject, missingComponents);
                        if (dialog != null) {
                            dialog.setTitle("Install Missing Components");
                            if (dialog.showAndGet()) {
                                GfxTraceEditor.this.connect();
                            }
                        }
                    });
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("GPU debugging SDK not installed", (Component)link);
                    return;
                }
                try {
                    GfxTraceEditor.this.doConnect();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        GfxTraceEditor.this.myView.add((Component)GfxTraceEditor.this.myMainUi, (Object)"Center");
                        GfxTraceEditor.this.myLoadingPanel.stopLoading();
                    });
                }
                catch (GapisInitException e2) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt(e2.getMessage(), null);
                }
            }
        });
    }

    private void doConnect() throws GapisInitException {
        if (!GfxTraceEditor.isEnabled()) {
            throw GapisInitException.notEnabled();
        }
        this.connectToServer();
        String status = "";
        try {
            status = "fetch schema";
            this.fetchSchema();
            status = "fetch feature list";
            GapisFeatures features = this.myGapisConnection.getFeatures();
            this.fetchFeatures(features);
            if (features.hasRpcStringTables()) {
                status = "fetch string table";
                this.fetchStringTable();
            }
        }
        catch (RpcException | ExecutionException | TimeoutException e) {
            LOG.error("Failed to " + status, e);
            throw GapisInitException.initFailed();
        }
        this.fetchReplayDevice();
        this.fetchTrace(this.myFile);
        ApplicationManager.getApplication().invokeLater(() -> {
            List<ConnectionListener> list = this.myConnectionListeners;
            synchronized (list) {
                for (ConnectionListener listener : this.myConnectionListeners) {
                    listener.onConnection(this.myGapisConnection);
                }
            }
        });
    }

    private void fetchSchema() throws ExecutionException, RpcException, TimeoutException {
        Message schema = (Message)Rpc.get(this.myClient.getSchema(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.info("Schema with " + schema.entities.length + " classes, " + schema.constants.length + " constant sets");
        int atoms = 0;
        for (Entity entity : schema.entities) {
            if (AtomMetadata.find(entity) != null) {
                ++atoms;
            }
            Dynamic.register((Entity)entity);
        }
        LOG.info("Schema with " + atoms + " atoms");
        for (Entity entity : schema.constants) {
            ConstantSet.register((ConstantSet)entity);
        }
    }

    private void fetchFeatures(GapisFeatures features) throws ExecutionException, RpcException, TimeoutException {
        Object[] list = (String[])Rpc.get(this.myClient.getFeatures(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        features.setFeatureList((String[])list);
        LOG.info("GAPIS features: " + Arrays.toString(list));
    }

    private void fetchStringTable() throws ExecutionException, RpcException, TimeoutException {
        Info[] infos = (Info[])Rpc.get(this.myClient.getAvailableStringTables(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        if (infos.length == 0) {
            LOG.warn("No string tables available");
            return;
        }
        Info info = infos[0];
        StringTable table = (StringTable)Rpc.get(this.myClient.getStringTable(info), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        table.setCurrent();
    }

    private void fetchReplayDevice() throws GapisInitException {
        for (int i = 0; i < 30; ++i) {
            try {
                DevicePath[] devices = (DevicePath[])Rpc.get(this.getClient().getDevices(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
                if (devices != null && devices.length >= 1) {
                    this.activatePath(devices[0], (Object)this);
                    return;
                }
            }
            catch (RpcException | ExecutionException | TimeoutException devices) {
                // empty catch block
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw GapisInitException.noReplayDevice();
    }

    private void fetchTrace(VirtualFile file) throws GapisInitException {
        try {
            ListenableFuture<CapturePath> captureF;
            if (file.getFileSystem().getProtocol().equals("file")) {
                LOG.info("Load gfxtrace in " + file.getPresentableName());
                if (file.getLength() == 0L) {
                    throw GapisInitException.emptyTrace(file);
                }
                captureF = this.myClient.loadCapture(file.getCanonicalPath());
            } else {
                byte[] data = file.contentsToByteArray();
                LOG.info("Upload " + data.length + " bytes of gfxtrace as " + file.getPresentableName());
                if (data.length == 0) {
                    throw GapisInitException.emptyTrace(file);
                }
                captureF = this.myClient.importCapture(file.getPresentableName(), data);
            }
            CapturePath path = (CapturePath)Rpc.get(captureF, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (path == null) {
                throw GapisInitException.invalidTrace(file);
            }
            this.activatePath(path, (Object)this);
        }
        catch (RpcException | IOException | ExecutionException | TimeoutException e) {
            LOG.warn("Loading trace failed", e);
            throw GapisInitException.loadTraceFailed(file);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getProject"));
        }
        return project;
    }

    @NotNull
    public JComponent getComponent() {
        LoadablePanel loadablePanel = this.myLoadingPanel;
        if (loadablePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getComponent"));
        }
        return loadablePanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("GfxTraceView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getName"));
        }
        return "GfxTraceView";
    }

    public String getSessionName() {
        return this.myFile.getName();
    }

    public void activatePath(final @NotNull Path path, final Object source) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "activatePath"));
        }
        final PathListener.PathEvent event = new PathListener.PathEvent(path, source);
        Runnable eventDispatch = new Runnable(){

            @Override
            public void run() {
                LOG.info("Activate path " + path + ", source: " + source.getClass().getName());
                for (PathListener listener : GfxTraceEditor.this.myPathListeners) {
                    listener.notifyPath(event);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            eventDispatch.run();
        } else {
            application.invokeLater(eventDispatch);
        }
    }

    public void addPathListener(@NotNull PathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPathListener"));
        }
        this.myPathListeners.add(listener);
    }

    public void addConnectionListener(@NotNull ConnectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addConnectionListener"));
        }
        this.myConnectionListeners.add(listener);
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public ServiceClient getClient() {
        ServiceClient serviceClient = this.myClient;
        if (serviceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getClient"));
        }
        return serviceClient;
    }

    @NotNull
    public AtomStream getAtomStream() {
        AtomStream atomStream = this.myAtomStream;
        if (atomStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getAtomStream"));
        }
        return atomStream;
    }

    @NotNull
    public GpuState getGpuState() {
        GpuState gpuState = this.myState;
        if (gpuState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getGpuState"));
        }
        return gpuState;
    }

    @NotNull
    public ListeningExecutorService getExecutor() {
        ListeningExecutorService listeningExecutorService = this.myExecutor;
        if (listeningExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getExecutor"));
        }
        return listeningExecutorService;
    }

    public void dispose() {
        long totalTime = System.currentTimeMillis() - this.myStartTime;
        GfxTraceUtil.trackEvent("gfxTraceClosed", null, (int)totalTime);
        this.shutdown();
    }

    private void connectToServer() throws GapisInitException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        this.myGapisConnection = GapisProcess.connect();
        if (!this.myGapisConnection.isConnected()) {
            throw GapisInitException.notConnected();
        }
        try {
            this.myClient = new ServiceClientCache(this.myGapisConnection.createServiceClient(this.myExecutor), this.myExecutor);
        }
        catch (IOException e) {
            LOG.error("Unable to create client from connection", (Throwable)e);
            throw GapisInitException.notConnected();
        }
    }

    private void setLoadingErrorTextOnEdt(final @NotNull String error, final @Nullable Component errorComponent) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setLoadingErrorTextOnEdt"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxTraceEditor.this.myLoadingPanel.showLoadingError(error, errorComponent);
            }
        });
    }

    private void shutdown() {
        if (this.myGapisConnection != null) {
            this.myGapisConnection.close();
            this.myGapisConnection = null;
        }
        this.myExecutor.shutdown();
    }

    public static interface ConnectionListener {
        public void onConnection(GapisConnection var1);
    }

    private static class GapisInitException
    extends Exception {
        public GapisInitException(String message) {
            super(message);
        }

        public static GapisInitException notEnabled() {
            return new GapisInitException("Graphics debugger not enabled on this system");
        }

        public static GapisInitException notConnected() {
            return new GapisInitException("Failed to connect to the graphics debugger");
        }

        public static GapisInitException initFailed() {
            return new GapisInitException("Failed to initialize the graphics debugger");
        }

        public static GapisInitException noReplayDevice() {
            return new GapisInitException("No usable replay device found");
        }

        public static GapisInitException emptyTrace(VirtualFile file) {
            return new GapisInitException("Empty trace file " + file.getPresentableName());
        }

        public static GapisInitException invalidTrace(VirtualFile file) {
            return new GapisInitException("Invalid/Corrupted trace file " + file.getPresentableName());
        }

        public static GapisInitException loadTraceFailed(VirtualFile file) {
            return new GapisInitException("Failed to load trace file " + file.getPresentableName());
        }
    }
}

