/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.editors.gfxtrace.ClassFilterRequestor;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.google.common.collect.Lists;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.FutureResult;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.tools.jdi.StringReferenceImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class GapiiLibraryLoader {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GapiiLibraryLoader.class);
    private static final String DEVICE_TMP_DIR = "/data/local/tmp";
    private static final long LIB_INSTALLATION_TIMEOUT_MS = 60000L;
    private IDevice myDevice;
    private Project myProject;

    public GapiiLibraryLoader(@NotNull Project project, @NotNull IDevice device) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GapiiLibraryLoader", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/GapiiLibraryLoader", "<init>"));
        }
        this.myProject = project;
        this.myDevice = device;
    }

    public void connectToProcessAndInstallLibraries(@NotNull String pkg) throws Exception {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/android/tools/idea/editors/gfxtrace/GapiiLibraryLoader", "connectToProcessAndInstallLibraries"));
        }
        long startTime = System.nanoTime();
        LOG.debug("Attaching to " + pkg);
        AndroidJavaDebugger debugger = new AndroidJavaDebugger();
        Client client = this.myDevice.getClient(pkg);
        if (client == null) {
            throw new RuntimeException("Failed to attach to process.");
        }
        final FutureResult evalCompletion = new FutureResult();
        EdtExecutorService.getInstance().submit(() -> {
            debugger.attachToClient(this.myProject, client);
            DebuggerSession session = debugger.getDebuggerSession(client);
            final DebugProcessImpl process = session.getProcess();
            LOG.debug("Waiting debugger to attach to the process.");
            process.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapter(){

                public void processAttached(DebugProcess ignored) {
                    LOG.debug("Waiting for Application.onCreate() to be called.");
                    AppOnCreateFilter filter = new AppOnCreateFilter((FutureResult<Void>)evalCompletion);
                    process.getRequestsManager().createMethodEntryRequest((FilteredRequestor)filter).enable();
                }
            });
        });
        try {
            evalCompletion.get(60000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeout) {
            EdtExecutorService.getInstance().submit(() -> {
                DebuggerSession session = debugger.getDebuggerSession(client);
                if (session != null) {
                    DebugProcessImpl process = session.getProcess();
                    process.getManagerThread().terminateAndInvoke((DebuggerCommandImpl)process.createStopCommand(true), 1000);
                }
            });
            throw timeout;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof Exception) {
                throw (Exception)ex.getCause();
            }
            throw ex;
        }
        finally {
            EdtExecutorService.getInstance().submit(() -> {
                DebuggerSession session = debugger.getDebuggerSession(client);
                if (session != null) {
                    DebugProcessImpl process = session.getProcess();
                    process.getProcessHandler().detachProcess();
                    ExecutionManager.getInstance((Project)this.myProject).getContentManager().removeRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), session.getXDebugSession().getRunContentDescriptor());
                }
            });
        }
        long durationMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        LOG.debug("Library installation took " + (double)durationMs / 1000.0 + "s");
    }

    public static class DeviceNotSupportedException
    extends Exception {
        public DeviceNotSupportedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private class AppOnCreateFilter
    extends ClassFilterRequestor {
        private final FutureResult<Void> myEvalCompletion;

        public AppOnCreateFilter(FutureResult<Void> evalCompletion) {
            super("android.app.Application");
            this.myEvalCompletion = evalCompletion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
            if (!"onCreate".equals(event.location().method().name())) {
                return false;
            }
            event.request().disable();
            LOG.debug("Application.onCreate() called, running library installation.");
            String abi = (String)GapiiLibraryLoader.this.myDevice.getAbis().get(0);
            try {
                Value res = this.evaluate(CodeFragmentKind.EXPRESSION, "android.os.Build.CPU_ABI", action.getSuspendContext());
                abi = ((StringReferenceImpl)res).value();
            }
            catch (Throwable t) {
                LOG.warn("Couldn't determine ABI from android.os.Build.CPU_ABI. Defaulting to device primary ABI.", t);
            }
            ArrayList libraries = Lists.newArrayList();
            try {
                libraries.add(GapiPaths.findInterceptorLibrary(abi));
            }
            catch (IOException ex) {
                LOG.info("Skipping libinterceptor.so: " + ex.getMessage());
            }
            try {
                libraries.add(GapiPaths.findTraceLibrary(abi));
            }
            catch (IOException ex) {
                DeviceNotSupportedException e = new DeviceNotSupportedException("Couldn't find libgapii.so for target ABI '" + abi + "'", ex);
                this.myEvalCompletion.setException((Throwable)e);
                return false;
            }
            try {
                for (File lib : libraries) {
                    String remoteFilePath = "/data/local/tmp/" + lib.getName();
                    try {
                        GapiiLibraryLoader.this.myDevice.pushFile(lib.getAbsolutePath(), remoteFilePath);
                        this.evaluate(CodeFragmentKind.CODE_BLOCK, this.getLoaderSnippet(lib), action.getSuspendContext());
                    }
                    finally {
                        GapiiLibraryLoader.this.myDevice.executeShellCommand("rm " + remoteFilePath, NullOutputReceiver.getReceiver());
                    }
                }
                this.myEvalCompletion.set(null);
            }
            catch (Throwable t) {
                this.myEvalCompletion.setException(t);
            }
            return false;
        }

        private Value evaluate(CodeFragmentKind kind, String snippet, SuspendContextImpl suspendContext) throws EvaluateException {
            return (Value)ApplicationManager.getApplication().runReadAction(() -> {
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy(), (Value)suspendContext.getFrameProxy().getStackFrame().thisObject());
                ExpressionEvaluator evaluator = EvaluatorBuilderImpl.build((TextWithImports)new TextWithImportsImpl(kind, snippet), null, null, (Project)GapiiLibraryLoader.this.myProject);
                return evaluator.evaluate((EvaluationContext)evaluationContext);
            });
        }

        private String getLoaderSnippet(File lib) {
            return "  String TAG = \"gapii-init\";\n  String libName = \"" + lib.getName() + "\";\n  java.io.File inFile = new java.io.File(\"" + GapiiLibraryLoader.DEVICE_TMP_DIR + "\", libName);\n  java.io.File outFile = new java.io.File(((android.app.Application) this).getFilesDir(), libName);\n  long libSize = inFile.length();\n\n  android.util.Log.d(TAG, String.format(\"Copying %d bytes to %s.\", libSize, outFile));\n  java.nio.channels.FileChannel inChannel = new java.io.FileInputStream(inFile).getChannel();\n  java.nio.channels.FileChannel outChannel = new java.io.FileOutputStream(outFile).getChannel();\n  long remaining = libSize;\n  while (remaining > 0) {\n    remaining -= outChannel.transferFrom(inChannel, libSize - remaining, remaining); \n  }\n\n  outChannel.close();\n  inChannel.close();\n\n  android.util.Log.d(TAG, \"Library copied, loading.\");\n  if (android.os.Build.VERSION.SDK_INT == 24) {\n    Runtime.getRuntime().doLoad(outFile.toString(), null);\n  } else {\n    System.load(outFile.toString());\n  }\n";
        }
    }
}

