/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.generated.file.ro");
    private final Project myProject;
    private final GeneratedSourceFileChangeTracker myGeneratedSourceFileChangeTracker;

    public GeneratedFileNotificationProvider(Project project, GeneratedSourceFileChangeTracker changeTracker) {
        this.myProject = project;
        this.myGeneratedSourceFileChangeTracker = changeTracker;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/GeneratedFileNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/GeneratedFileNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/idea/editors/GeneratedFileNotificationProvider", "createNotificationPanel"));
        }
        AndroidProject androidProject = Projects.getAndroidModel(file, this.myProject);
        if (androidProject == null) {
            return null;
        }
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)androidProject.getBuildFolder(), (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return null;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false)) {
            if (this.myGeneratedSourceFileChangeTracker.isEditedGeneratedFile(file)) {
                return null;
            }
            VirtualFile explodedBundled = buildFolder.findChild("exploded-bundles");
            if (explodedBundled == null) {
                explodedBundled = buildFolder.findChild("exploded-aar");
            }
            boolean inAar = explodedBundled != null && VfsUtilCore.isAncestor((VirtualFile)explodedBundled, (VirtualFile)file, (boolean)true);
            String text = inAar ? "Resource files inside Android library archive files (.aar) should not be edited" : "Files under the build folder are generated and should not be edited.";
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(text);
            return panel;
        }
        return null;
    }
}

