/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.DoubleProperty;
import com.android.tools.idea.ui.properties.core.DoubleValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableDouble;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.android.tools.idea.ui.properties.expressions.double_.DoubleExpression;
import com.google.common.base.Optional;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdDeviceData {
    private StringProperty myName = new StringValueProperty();
    private OptionalProperty<IdDisplay> myDeviceType = new OptionalValueProperty<IdDisplay>();
    private StringProperty myManufacturer = new StringValueProperty();
    private StringProperty myTagId = new StringValueProperty();
    private DoubleProperty myDiagonalScreenSize = new DoubleValueProperty();
    private IntProperty myScreenResolutionWidth = new IntValueProperty();
    private IntProperty myScreenResolutionHeight = new IntValueProperty();
    private ObjectProperty<Storage> myRamStorage = new ObjectValueProperty<Storage>(new Storage(0L, Storage.Unit.MiB));
    private BoolProperty myHasHardwareButtons = new BoolValueProperty();
    private BoolProperty myHasHardwareKeyboard = new BoolValueProperty();
    private OptionalProperty<Navigation> myNavigation = new OptionalValueProperty<Navigation>();
    private BoolProperty mySupportsLandscape = new BoolValueProperty();
    private BoolProperty mySupportsPortrait = new BoolValueProperty();
    private BoolProperty myHasBackCamera = new BoolValueProperty();
    private BoolProperty myHasFrontCamera = new BoolValueProperty();
    private BoolProperty myHasAccelerometer = new BoolValueProperty();
    private BoolProperty myHasGyroscope = new BoolValueProperty();
    private BoolProperty myHasGps = new BoolValueProperty();
    private BoolProperty myHasProximitySensor = new BoolValueProperty();
    private OptionalProperty<File> myCustomSkinFile = new OptionalValueProperty<File>();
    private BoolValueProperty myIsTv = new BoolValueProperty();
    private BoolValueProperty myIsWear = new BoolValueProperty();
    private BoolValueProperty myIsScreenRound = new BoolValueProperty();
    private IntValueProperty myScreenChinSize = new IntValueProperty();
    private State myDefaultState;
    private File myLastSkinFolder;
    private Dimension myLastSkinDimension;
    private OptionalProperty<Software> mySoftware = new OptionalValueProperty<Software>();
    private DoubleExpression myScreenDpi = new DoubleExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myDiagonalScreenSize}){

        @Override
        @NotNull
        public Double get() {
            Double d = AvdScreenData.calculateDpi(((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue(), ((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue(), (Double)AvdDeviceData.this.myDiagonalScreenSize.get());
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$1", "get"));
            }
            return d;
        }
    };
    private ObservableBool mySkinSizeIsCompatible = new BooleanExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myCustomSkinFile}){

        @Override
        @NotNull
        public Boolean get() {
            if (!((Optional)AvdDeviceData.this.myCustomSkinFile.get()).isPresent()) {
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$2", "get"));
                }
                return bl;
            }
            Dimension dimension = AvdDeviceData.this.getSkinDimension((File)AvdDeviceData.this.myCustomSkinFile.getValueOrNull());
            Boolean bl = dimension == null || dimension.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue() || dimension.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$2", "get"));
            }
            return bl;
        }
    };

    public AvdDeviceData() {
        Software software = new Software();
        software.setLiveWallpaperSupport(true);
        software.setGlVersion("2.0");
        this.mySoftware.setValue(software);
        this.myManufacturer.set("User");
        this.initDefaultValues();
        this.myDiagonalScreenSize.addConstraint(value -> Math.max(0.1, value));
        this.myScreenResolutionWidth.addConstraint(value -> Math.max(1, value));
        this.myScreenResolutionHeight.addConstraint(value -> Math.max(1, value));
    }

    public AvdDeviceData(@Nullable Device device, @Nullable SystemImageDescription systemImage) {
        this();
        if (device != null) {
            this.updateValuesFromDevice(device, systemImage);
        }
    }

    private static String getUniqueId(@Nullable String id) {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getUniqueId(id);
    }

    public void setUniqueName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDeviceData", "setUniqueName"));
        }
        this.myName.set(AvdDeviceData.getUniqueId(name));
    }

    @NotNull
    public StringProperty name() {
        StringProperty stringProperty = this.myName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "name"));
        }
        return stringProperty;
    }

    @NotNull
    public OptionalProperty<IdDisplay> deviceType() {
        OptionalProperty<IdDisplay> optionalProperty = this.myDeviceType;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "deviceType"));
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty manufacturer() {
        StringProperty stringProperty = this.myManufacturer;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "manufacturer"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty tagId() {
        StringProperty stringProperty = this.myTagId;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "tagId"));
        }
        return stringProperty;
    }

    @NotNull
    public DoubleProperty diagonalScreenSize() {
        DoubleProperty doubleProperty = this.myDiagonalScreenSize;
        if (doubleProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "diagonalScreenSize"));
        }
        return doubleProperty;
    }

    @NotNull
    public IntProperty screenResolutionWidth() {
        IntProperty intProperty = this.myScreenResolutionWidth;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "screenResolutionWidth"));
        }
        return intProperty;
    }

    @NotNull
    public IntProperty screenResolutionHeight() {
        IntProperty intProperty = this.myScreenResolutionHeight;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "screenResolutionHeight"));
        }
        return intProperty;
    }

    @NotNull
    public ObservableDouble screenDpi() {
        DoubleExpression doubleExpression = this.myScreenDpi;
        if (doubleExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "screenDpi"));
        }
        return doubleExpression;
    }

    @NotNull
    public ObjectProperty<Storage> ramStorage() {
        ObjectProperty<Storage> objectProperty = this.myRamStorage;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "ramStorage"));
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty hasHardwareButtons() {
        BoolProperty boolProperty = this.myHasHardwareButtons;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasHardwareButtons"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasHardwareKeyboard() {
        BoolProperty boolProperty = this.myHasHardwareKeyboard;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasHardwareKeyboard"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<Navigation> navigation() {
        OptionalProperty<Navigation> optionalProperty = this.myNavigation;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "navigation"));
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty supportsLandscape() {
        BoolProperty boolProperty = this.mySupportsLandscape;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "supportsLandscape"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty supportsPortrait() {
        BoolProperty boolProperty = this.mySupportsPortrait;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "supportsPortrait"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasFrontCamera() {
        BoolProperty boolProperty = this.myHasFrontCamera;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasFrontCamera"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasBackCamera() {
        BoolProperty boolProperty = this.myHasBackCamera;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasBackCamera"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasAccelerometer() {
        BoolProperty boolProperty = this.myHasAccelerometer;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasAccelerometer"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasGyroscope() {
        BoolProperty boolProperty = this.myHasGyroscope;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasGyroscope"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasGps() {
        BoolProperty boolProperty = this.myHasGps;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasGps"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasProximitySensor() {
        BoolProperty boolProperty = this.myHasProximitySensor;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "hasProximitySensor"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<Software> software() {
        OptionalProperty<Software> optionalProperty = this.mySoftware;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "software"));
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<File> customSkinFile() {
        OptionalProperty<File> optionalProperty = this.myCustomSkinFile;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "customSkinFile"));
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty isTv() {
        BoolValueProperty boolValueProperty = this.myIsTv;
        if (boolValueProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "isTv"));
        }
        return boolValueProperty;
    }

    @NotNull
    public BoolProperty isWear() {
        BoolValueProperty boolValueProperty = this.myIsWear;
        if (boolValueProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "isWear"));
        }
        return boolValueProperty;
    }

    @NotNull
    public BoolProperty isScreenRound() {
        BoolValueProperty boolValueProperty = this.myIsScreenRound;
        if (boolValueProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "isScreenRound"));
        }
        return boolValueProperty;
    }

    @NotNull
    public IntProperty screenChinSize() {
        IntValueProperty intValueProperty = this.myScreenChinSize;
        if (intValueProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "screenChinSize"));
        }
        return intValueProperty;
    }

    @NotNull
    public ObservableBool compatibleSkinSize() {
        ObservableBool observableBool = this.mySkinSizeIsCompatible;
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "compatibleSkinSize"));
        }
        return observableBool;
    }

    private void initDefaultValues() {
        this.myName.set(AvdDeviceData.getUniqueId(null));
        this.myDiagonalScreenSize.set(5.0);
        this.myScreenResolutionWidth.set(1080);
        this.myScreenResolutionHeight.set(1920);
        this.myRamStorage.set(new Storage(2L, Storage.Unit.GiB));
        this.myHasHardwareButtons.set(false);
        this.myHasHardwareKeyboard.set(false);
        this.myNavigation.setValue(Navigation.NONAV);
        this.mySupportsPortrait.set(true);
        this.mySupportsLandscape.set(true);
        this.myHasFrontCamera.set(true);
        this.myHasBackCamera.set(true);
        this.myHasAccelerometer.set(true);
        this.myHasGyroscope.set(true);
        this.myHasGps.set(true);
        this.myHasProximitySensor.set(true);
    }

    @Nullable
    private Dimension getSkinDimension(@Nullable File skinFolder) {
        if (!FileUtil.filesEqual((File)skinFolder, (File)this.myLastSkinFolder)) {
            this.myLastSkinDimension = AvdDeviceData.computeSkinDimension(skinFolder);
            this.myLastSkinFolder = skinFolder;
        }
        return this.myLastSkinDimension;
    }

    @Nullable
    private static Dimension computeSkinDimension(@Nullable File skinFolder) {
        if (skinFolder == null || FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            return null;
        }
        File skinLayoutFile = new File(skinFolder, "layout");
        if (!skinLayoutFile.isFile()) {
            return null;
        }
        FileOp fop = FileOpUtils.create();
        SkinLayoutDefinition skin = SkinLayoutDefinition.parseFile(skinLayoutFile, fop);
        if (skin == null) {
            return null;
        }
        int height = StringUtil.parseInt((String)skin.get("parts.device.display.height"), (int)-1);
        int width = StringUtil.parseInt((String)skin.get("parts.device.display.width"), (int)-1);
        if (height <= 0 || width <= 0) {
            return null;
        }
        return new Dimension(width, height);
    }

    public void updateValuesFromDevice(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdDeviceData", "updateValuesFromDevice"));
        }
        this.myName.set(device.getDisplayName());
        String tagId = device.getTagId();
        if (((String)this.myTagId.get()).isEmpty()) {
            this.myTagId.set(SystemImage.DEFAULT_TAG.getId());
            this.myDeviceType.setValue(SystemImage.DEFAULT_TAG);
        } else {
            for (IdDisplay tag : AvdWizardUtils.ALL_DEVICE_TAGS) {
                if (!tag.getId().equals(tagId)) continue;
                this.myDeviceType.setValue(tag);
                break;
            }
        }
        Hardware defaultHardware = device.getDefaultHardware();
        Screen screen = defaultHardware.getScreen();
        this.myDiagonalScreenSize.set(screen.getDiagonalLength());
        this.myScreenResolutionWidth.set(screen.getXDimension());
        this.myScreenResolutionHeight.set(screen.getYDimension());
        this.myRamStorage.set(AvdWizardUtils.getDefaultRam(defaultHardware));
        this.myHasHardwareButtons.set(defaultHardware.getButtonType() == ButtonType.HARD);
        this.myHasHardwareKeyboard.set(defaultHardware.getKeyboard() != Keyboard.NOKEY);
        this.myNavigation.setValue(defaultHardware.getNav());
        List states = device.getAllStates();
        this.mySupportsPortrait.set(false);
        this.mySupportsLandscape.set(false);
        for (State state : states) {
            if (state.isDefaultState()) {
                this.myDefaultState = state;
            }
            if (state.getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                this.mySupportsPortrait.set(true);
            }
            if (!state.getOrientation().equals((Object)ScreenOrientation.LANDSCAPE)) continue;
            this.mySupportsLandscape.set(true);
        }
        this.myHasFrontCamera.set(defaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myHasBackCamera.set(defaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myHasAccelerometer.set(defaultHardware.getSensors().contains(Sensor.ACCELEROMETER));
        this.myHasGyroscope.set(defaultHardware.getSensors().contains(Sensor.GYROSCOPE));
        this.myHasGps.set(defaultHardware.getSensors().contains(Sensor.GPS));
        this.myHasProximitySensor.set(defaultHardware.getSensors().contains(Sensor.PROXIMITY_SENSOR));
        this.myIsTv.set(HardwareConfigHelper.isTv((Device)device));
        this.myIsWear.set(HardwareConfigHelper.isWear((Device)device));
        this.myIsScreenRound.set(device.isScreenRound());
        this.myScreenChinSize.set(device.getChinSize());
        this.updateSkinFromDeviceAndSystemImage(device, systemImage);
    }

    public void updateSkinFromDeviceAndSystemImage(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdDeviceData", "updateSkinFromDeviceAndSystemImage"));
        }
        Hardware defaultHardware = device.getDefaultHardware();
        File skinFile = AvdWizardUtils.resolveSkinPath(defaultHardware.getSkinFile(), systemImage, FileOpUtils.create());
        this.myCustomSkinFile.setValue(skinFile == null ? AvdWizardUtils.NO_SKIN : skinFile);
    }

    @NotNull
    public Dimension getDeviceScreenDimension() {
        int finalHeight;
        int finalWidth;
        int width = (Integer)this.myScreenResolutionWidth.get();
        int height = (Integer)this.myScreenResolutionHeight.get();
        ScreenOrientation orientation = this.getDefaultDeviceOrientation();
        assert (width > 0 && height > 0);
        if (orientation == ScreenOrientation.LANDSCAPE) {
            finalWidth = Math.max(width, height);
            finalHeight = Math.min(width, height);
        } else {
            finalWidth = Math.min(width, height);
            finalHeight = Math.max(width, height);
        }
        Dimension dimension = new Dimension(finalWidth, finalHeight);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "getDeviceScreenDimension"));
        }
        return dimension;
    }

    @NotNull
    public ScreenOrientation getDefaultDeviceOrientation() {
        if (this.myDefaultState != null && this.myDefaultState.getOrientation() == ScreenOrientation.LANDSCAPE && ((Boolean)this.mySupportsLandscape.get()).booleanValue()) {
            ScreenOrientation screenOrientation = ScreenOrientation.LANDSCAPE;
            if (screenOrientation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "getDefaultDeviceOrientation"));
            }
            return screenOrientation;
        }
        ScreenOrientation screenOrientation = (Boolean)this.mySupportsPortrait.get() != false ? ScreenOrientation.PORTRAIT : ((Boolean)this.mySupportsLandscape.get() != false ? ScreenOrientation.LANDSCAPE : ScreenOrientation.SQUARE);
        if (screenOrientation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData", "getDefaultDeviceOrientation"));
        }
        return screenOrientation;
    }
}

