/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ApkEntryImpl
implements ApkEntry {
    private final VirtualFile myFile;
    @Nullable
    private final String myOriginalName;
    private final long mySize;
    private long myCompressedSize;

    ApkEntryImpl(@NotNull VirtualFile file, @Nullable String originalName, long size) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/ApkEntryImpl", "<init>"));
        }
        this.myCompressedSize = -1L;
        this.myFile = file;
        this.myOriginalName = originalName;
        this.mySize = size;
    }

    @Override
    public boolean isCompressedSizeKnown() {
        return this.myCompressedSize >= 0L;
    }

    @Override
    public long getCompressedSize() {
        return this.myCompressedSize;
    }

    @Override
    public void setCompressedSize(long compressedSize) {
        this.myCompressedSize = compressedSize;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myOriginalName != null ? this.myOriginalName : this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEntryImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEntryImpl", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEntryImpl", "getPath"));
        }
        return string;
    }

    @Override
    public long getSize() {
        return this.mySize;
    }
}

