/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view.actions;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.view.CdiBeansRecursivePanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.CdiCoreIcons;
import org.jetbrains.annotations.NotNull;

public class ShowBeansAction
extends ToggleAction {
    private CdiBeansRecursivePanel myPanel;

    public ShowBeansAction(@NotNull CdiBeansRecursivePanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/cdi/view/actions/ShowBeansAction", "<init>"));
        }
        this.myPanel = panel;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText("Show Beans");
        e.getPresentation().setIcon(CdiCoreIcons.CdiBean);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myPanel.isShowBeans();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        CdiViewSettings viewSettings;
        if (state != this.myPanel.isShowBeans() && (viewSettings = CdiProjectComponent.getInstance(this.myPanel.getProject()).getState()) != null) {
            viewSettings.showBeans = state;
            this.myPanel.updatePanel();
        }
    }
}

