/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.toolWindow.tree.nodes;

import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.toolWindow.tree.nodes.AbstractCdiTypeNode;
import com.intellij.cdi.toolWindow.tree.nodes.CdiModuleNode;
import com.intellij.cdi.toolWindow.tree.nodes.CdiNodeTypes;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.javaee.toolwindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.javaee.toolwindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import java.util.HashSet;
import java.util.List;

public class NamedNode
extends AbstractCdiTypeNode {
    private final Module myModule;

    public NamedNode(Module module, CdiModuleNode cdiModuleNode) {
        super(cdiModuleNode, module, CdiNodeTypes.NAMED, CdiBundle.message("actions.show.named", new Object[0]));
        this.myModule = module;
    }

    @Override
    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(PlatformIcons.ANNOTATION_TYPE_ICON);
    }

    public SimpleNode[] getChildren() {
        List<CdiNamedBean> cdiNamedBean = CdiJamModel.getModel(this.getModule()).getNamedBeans();
        HashSet<1> nodes = new HashSet<1>();
        for (final CdiNamedBean beanCdi : cdiNamedBean) {
            nodes.add(new AnnotatedMembersNode<PsiMember>(this.myModule, beanCdi.getPsiElement(), (SimpleNode)this){

                protected String getMemberName() {
                    return beanCdi.getName();
                }

                protected String getQualifiedName() {
                    PsiType type = beanCdi.getType();
                    return type != null ? type.getPresentableText() : null;
                }
            });
        }
        return (SimpleNode[])nodes.toArray(new PsiMemberSimpleNode[nodes.size()]);
    }

    public int getWeight() {
        return 1;
    }
}

