/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.model.impl;

import com.intellij.cdi.model.CdiBeansXmlDomModelManager;
import com.intellij.cdi.model.CdiBeansXmlModel;
import com.intellij.cdi.model.CdiBeansXmlModelFactory;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansXmlDomModelManagerImpl
extends CdiBeansXmlDomModelManager {
    private final CdiBeansXmlModelFactory myModelFactory;
    private final DomManager myDomManager;

    public CdiBeansXmlDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myModelFactory = new CdiBeansXmlModelFactory(project);
    }

    @Override
    public boolean isBeansXml(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/model/impl/CdiBeansXmlDomModelManagerImpl", "isBeansXml"));
        }
        return this.myDomManager.getFileElement(file, Beans.class) != null;
    }

    @Override
    @Nullable
    public CdiBeansXmlModel getBeansXmlModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/model/impl/CdiBeansXmlDomModelManagerImpl", "getBeansXmlModel"));
        }
        return this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    @NotNull
    public List<CdiBeansXmlModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/model/impl/CdiBeansXmlDomModelManagerImpl", "getAllModels"));
        }
        List list = this.myModelFactory.getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/model/impl/CdiBeansXmlDomModelManagerImpl", "getAllModels"));
        }
        return list;
    }
}

