/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.manager;

import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.FieldProducerBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.MethodProducerBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDescriptorsFactory {
    private CdiDescriptorsFactory() {
    }

    @NotNull
    public static CdiBeanPsiClassDescriptor createCdiBeanDescriptor(PsiClass psiClass) {
        ManagedBeanDescriptor managedBeanDescriptor = new ManagedBeanDescriptor(psiClass);
        if (managedBeanDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/manager/CdiDescriptorsFactory", "createCdiBeanDescriptor"));
        }
        return managedBeanDescriptor;
    }

    @Nullable
    public static ProducerBeanDescriptor<? extends PsiMember> createProducerCdiBeanDescriptor(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/cdi/manager/CdiDescriptorsFactory", "createProducerCdiBeanDescriptor"));
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javax.enterprise.inject.Produces", (boolean)true)) {
            if (member instanceof PsiMethod) {
                return new MethodProducerBeanDescriptor((PsiMethod)member);
            }
            if (member instanceof PsiField) {
                return new FieldProducerBeanDescriptor((PsiField)member);
            }
        }
        return null;
    }
}

