/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CdiStereotypeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiStereotypeInspection", "checkClass"));
        }
        if (aClass.isAnnotationType() && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Collections.singleton("javax.enterprise.inject.Stereotype"))) {
            CdiStereotypeInspection.checkStereotype(aClass, holder);
        }
    }

    private static void checkStereotype(PsiClass aClass, ProblemsHolder holder) {
        PsiAnnotation[] psiAnnotations;
        for (PsiAnnotation psiAnnotation : psiAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)aClass)) {
            if ("javax.inject.Named".equals(psiAnnotation.getQualifiedName())) {
                if (psiAnnotation.getParameterList().getAttributes().length == 0) continue;
                holder.registerProblem((PsiElement)psiAnnotation, CdiInspectionBundle.message("CdiStereotypeInspection.non.empty.named.annotations.not.allowed", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            holder.registerProblem((PsiElement)psiAnnotation, CdiInspectionBundle.message("CdiStereotypeInspection.qualified.annotations.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"javax.enterprise.inject.Typed"});
        if (annotation != null) {
            holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiStereotypeInspection.not.allowed.for.stereotypes", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.stereotype.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CdiStereotypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeInspection", "getShortName"));
        }
        return "CdiStereotypeInspection";
    }
}

