/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiDisposerMethodInspection
extends CdiBaseInspection {
    @Override
    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = CdiCommonUtils.getDisposerMethods(descriptor.getAnnotatedItem());
        for (PsiMethod method : methods) {
            if (CdiDisposerMethodInspection.getDisposeParameters(method).size() <= 1) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiDisposerMethodInspection.too.many.dispose.parameters", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static Set<PsiParameter> getDisposeParameters(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/cdi/highlighting/CdiDisposerMethodInspection", "getDisposeParameters"));
        }
        HashSet<PsiParameter> disposedParameters = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.inject.Disposes", (boolean)true)) continue;
            disposedParameters.add(psiParameter);
        }
        return disposedParameters;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.disposer.method.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDisposerMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiDisposerMethodInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDisposerMethodInspection", "getShortName"));
        }
        return "CdiDisposerMethodInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDisposerMethodInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

